% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gui_cmd.R
\name{gui_cmd}
\alias{gui_cmd}
\alias{gui_load}
\alias{gui_source}
\alias{gui_save}
\alias{gui_import}
\alias{gui_export}
\alias{gui_report}
\alias{gui_setwd}
\alias{guiCmd}
\alias{guiLoad}
\alias{guiSource}
\alias{guiSave}
\alias{guiImport}
\alias{guiExport}
\alias{guiReport}
\alias{guiSetwd}
\title{Execute a command in the GUI client}
\usage{
gui_cmd(command, ...)

gui_load(...)

gui_source(...)

gui_save(...)

gui_import(...)

gui_export(...)

gui_report(...)

gui_setwd(...)

guiCmd(command, ...)

guiLoad(...)

guiSource(...)

guiSave(...)

guiImport(...)

guiExport(...)

guiReport(...)

guiSetwd(...)
}
\arguments{
\item{command}{The command string to execute in the GUI client.}

\item{...}{Parameters provided for the command to execute in the GUI client.}
}
\value{
The result of the command if it succeed, or \code{NULL} if the command
cannot be run (i.e., \code{.guiCmd()} is not defined in \code{SciViews:TempEnv}).
}
\description{
This function is not intended to be used at the command line
(except for debugging purposes). It executes a command string to a
(compatible) GUI client.
}
\details{
You must define a function \code{.guiCmd()} in the \code{SciViews:TempEnv}
environment that will take first argument as the name of the command to
execute (like \code{source}, \code{save}, \code{import}, etc.), and ... with arguments to
the command to send. Depending on your GUI, you should have code that
delegates the GUI elements (ex: display a dialog asking for a .Rdata file to
source) and then, execute the command in \R with the selected file as
attribute.
}
\seealso{
\code{\link[=get_temp]{get_temp()}}
}
\concept{graphical user interface (GUI) control}
\keyword{misc}
