\name{createSystemfitModel}
\alias{createSystemfitModel}
\title{Create a Model for systemfit}

\description{
   This function creates a model that can be estimated by \code{systemfit}.
   The data, disturbances, and --- if not provided by the user ---
   the coefficients as well as the disturbance covariance matrix
   are generated by random numbers.
}

\usage{
createSystemfitModel( nEq, nRegEq, nObs, coef = NULL, sigma = NULL )
}

\arguments{
   \item{nEq}{the number of equations.}
   \item{nRegEq}{the number of regressors in each equation
      (without the intercept).}
   \item{nObs}{the number of observations.}
   \item{coef}{an optional vector of coefficients.}
   \item{sigma}{an optional covariance matrix of the disturbance terms.}
}

\value{
   \code{createSystemfitModel} returns a list with following elements:

   \item{formula}{a list of the model equations
      (objects of class \code{formula}).}
   \item{data}{a \code{data.frame} that contains the data.}
   \item{coef}{a vector of (true) coefficients.}
   \item{sigma}{the covariance matrix of the disturbance terms.}
}

\author{Arne Henningsen \email{arne.henningsen@googlemail.com}}

\seealso{\code{\link{systemfit}}}


\examples{
## create a model by random numbers
systemfitModel <- createSystemfitModel( 3, 4, 100 )

## estimate this model by "SUR"
fitsur <- systemfit( systemfitModel$formula, "SUR", data = systemfitModel$data )

## compare the "true" and the estimated coefficients
cbind( systemfitModel$coef, coef( fitsur ) )
}

\keyword{models}

