% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{shrink_images}
\alias{shrink_images}
\title{Shrink images to a maximum width}
\usage{
shrink_images(
  width = 800,
  dir = ".",
  files = all_files("[.](png|jpe?g|webp)$", dir),
  tinify = FALSE
)
}
\arguments{
\item{width}{The desired maximum width of images.}

\item{dir}{The directory of images.}

\item{files}{A vector of image file paths. By default, this is all
\file{.png}, \file{.jpeg}, and \file{.webp} images under \code{dir}.}

\item{tinify}{Whether to compress images using \code{\link[=tinify]{tinify()}}.}
}
\description{
Use \code{\link[magick:transform]{magick::image_resize()}} to shrink an
image if its width is larger than the value specified by the argument
\code{width}, and optionally call \code{\link[=tinify]{tinify()}} to compress it.
}
\examples{
f = xfun:::all_files("[.](png|jpe?g)$", R.home("doc"))
file.copy(f, tempdir())
f = file.path(tempdir(), basename(f))
magick::image_info(magick::image_read(f))  # some widths are larger than 300
xfun::shrink_images(300, files = f)
magick::image_info(magick::image_read(f))  # all widths <= 300 now
file.remove(f)
}
