// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ffi;
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GtkSourceMark")]
    pub struct Mark(Object<ffi::GtkSourceMark, ffi::GtkSourceMarkClass>) @extends gtk::TextMark;

    match fn {
        type_ => || ffi::gtk_source_mark_get_type(),
    }
}

impl Mark {
    pub const NONE: Option<&'static Mark> = None;

    #[doc(alias = "gtk_source_mark_new")]
    pub fn new(name: Option<&str>, category: &str) -> Mark {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_source_mark_new(
                name.to_glib_none().0,
                category.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Mark`] objects.
    ///
    /// This method returns an instance of [`MarkBuilder`](crate::builders::MarkBuilder) which can be used to create [`Mark`] objects.
    pub fn builder() -> MarkBuilder {
        MarkBuilder::new()
    }
}

impl Default for Mark {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Mark`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MarkBuilder {
    builder: glib::object::ObjectBuilder<'static, Mark>,
}

impl MarkBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn category(self, category: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("category", category.into()),
        }
    }

    pub fn left_gravity(self, left_gravity: bool) -> Self {
        Self {
            builder: self.builder.property("left-gravity", left_gravity),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Mark`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Mark {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Mark>> Sealed for T {}
}

pub trait MarkExt: IsA<Mark> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_source_mark_get_category")]
    #[doc(alias = "get_category")]
    fn category(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::gtk_source_mark_get_category(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_mark_next")]
    #[must_use]
    fn next(&self, category: Option<&str>) -> Option<Mark> {
        unsafe {
            from_glib_none(ffi::gtk_source_mark_next(
                self.as_ref().to_glib_none().0,
                category.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_mark_prev")]
    #[must_use]
    fn prev(&self, category: Option<&str>) -> Option<Mark> {
        unsafe {
            from_glib_none(ffi::gtk_source_mark_prev(
                self.as_ref().to_glib_none().0,
                category.to_glib_none().0,
            ))
        }
    }
}

impl<O: IsA<Mark>> MarkExt for O {}
