<?xml version='1.0' encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>

<!-- Let override the preamble: -->
<!--   original source: dblatex/xsl/preamble.xsl -->
<!--   new features: corpauthor handling -->
<xsl:template match="book|article" mode="preamble">
  <xsl:param name="lang"/>
  <xsl:variable name="info" select="bookinfo|articleinfo|artheader|info"/>

  <xsl:text>% -----------------------------------------  &#10;</xsl:text>
  <xsl:text>% Autogenerated LaTeX file from XML DocBook  &#10;</xsl:text>
  <xsl:text>% -----------------------------------------  &#10;</xsl:text>
  <!-- Parameters to pass to python parser -->
  <xsl:call-template name="py.params.set"/>
  <xsl:text>\documentclass</xsl:text>
  <xsl:if test="$latex.class.options!=''">
    <xsl:value-of select="concat('[',$latex.class.options,']')"/>
  </xsl:if>
  <xsl:text>{</xsl:text>
  <xsl:choose>
    <xsl:when test="self::book">
      <xsl:value-of select="$latex.class.book"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$latex.class.article"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text>}&#10;</xsl:text>
  <xsl:text>\usepackage{ifthen}&#10;</xsl:text>
  <xsl:text>\newboolean{DBKIsBook}&#10;</xsl:text>
  <xsl:text>\setboolean{DBKIsBook}{</xsl:text>
  <xsl:choose>
    <xsl:when test="self::book">true</xsl:when>
    <xsl:otherwise>false</xsl:otherwise>
  </xsl:choose>
  <xsl:text>}&#10;</xsl:text>

  <xsl:variable name="external.docs">
    <xsl:call-template name="make.external.docs"/>
  </xsl:variable>

  <xsl:call-template name="encode.before.style">
    <xsl:with-param name="lang" select="$lang"/>
  </xsl:call-template>
  <xsl:text>\usepackage{fancybox}&#10;</xsl:text>
  <xsl:text>\usepackage{makeidx}&#10;</xsl:text>

  <xsl:call-template name="user.params.set"/>
  <!-- Load babel before the style (bug #babel/3875) -->
  <xsl:call-template name="babel.setup"/>

  <!-- Load xr before hyperref -->
  <xsl:if test="$external.docs != ''">
    <xsl:text>\usepackage{xr-hyper}&#10;</xsl:text>
  </xsl:if>

  <!-- Paper and Page setup -->
  <xsl:call-template name="page.setup"/>

  <xsl:text>\usepackage[hyperlink]{</xsl:text>
  <xsl:value-of select="$latex.style"/>
  <xsl:text>}&#10;</xsl:text>

  <xsl:call-template name="encode.after.style">
    <xsl:with-param name="lang" select="$lang"/>
  </xsl:call-template>
  <xsl:call-template name="lang.setup"/>
  <xsl:call-template name="image.setup"/>
  <xsl:call-template name="citation.setup"/>
  <xsl:call-template name="biblio.setup"/>
  <xsl:call-template name="annotation.setup"/>
  <xsl:call-template name="user.params.set2"/>
  <xsl:call-template name="inline.setup"/>
  <xsl:apply-templates select="." mode="docinfo"/>

  <!-- Document title -->
  <xsl:variable name="title">
    <xsl:apply-templates select="(title
                                 |info/title
                                 |bookinfo/title
                                 |articleinfo/title
                                 |artheader/title)[1]" mode="coverpage"/>
  </xsl:variable>
  <xsl:variable name="pdftitle">
    <xsl:apply-templates select="(title
                                 |info/title
                                 |bookinfo/title
                                 |articleinfo/title
                                 |artheader/title)[1]" mode="pdftitle"/>
  </xsl:variable>

  <!-- Get the Authors -->
  <xsl:variable name="authors">
    <xsl:if test="$info">
      <xsl:choose>
        <xsl:when test="$info/authorgroup/author">
          <xsl:apply-templates select="$info/authorgroup"/>
        </xsl:when>
        <xsl:when test="$info/author">
          <xsl:call-template name="person.name.list">
            <xsl:with-param name="person.list" select="$info/author"/>
          </xsl:call-template>
        </xsl:when>
				<!-- corpauthor handling -->
				<xsl:when test="$info/corpauthor">
					<xsl:call-template name="person.name">
						<xsl:with-param name="node" select="$info/corpauthor"/>
					</xsl:call-template>
				</xsl:when>
      </xsl:choose>
    </xsl:if>
  </xsl:variable>

  <xsl:text>\title{</xsl:text>
  <xsl:value-of select="$title"/>
  <xsl:text>}&#10;</xsl:text>
  <xsl:text>\author{</xsl:text>
  <xsl:value-of select="$authors"/>
  <xsl:text>}&#10;</xsl:text>

  <xsl:text>\hypersetup{%&#10;</xsl:text>
  <xsl:if test="$doc.pdfcreator.show='1'">
    <xsl:text>pdfcreator={DBLaTeX-</xsl:text>
    <xsl:value-of select="$version"/>
    <xsl:text>},%&#10;</xsl:text>
  </xsl:if>
  <xsl:text>pdftitle={</xsl:text>
  <xsl:value-of select="$pdftitle"/>
  <xsl:text>},%&#10;</xsl:text>
  <xsl:text>pdfauthor={</xsl:text>
  <xsl:value-of select="$authors"/>
  <xsl:text>}%&#10;</xsl:text>
  <xsl:text>}&#10;</xsl:text>

  <!-- The external documents -->
  <xsl:if test="$external.docs != ''">
    <xsl:value-of select="$external.docs"/>
  </xsl:if>

  <!-- Set the collaborator table -->
  <xsl:call-template name="collab.setup">
    <xsl:with-param name="authors" select="$authors"/>
  </xsl:call-template>

  <xsl:text>\makeindex&#10;</xsl:text>
  <xsl:text>\makeglossary&#10;</xsl:text>

  <!-- Apply the revision history here -->
  <xsl:apply-templates select="$info/revhistory"/>

  <xsl:call-template name="verbatim.setup"/>
</xsl:template>

<!-- Let override the refentry -->
<!--   original source: dblatex/xsl/refenrty.xsl -->
<!--   new features: pagebreak between man pages -->
<xsl:template match="refentry">
  <xsl:variable name="refmeta" select=".//refmeta"/>
  <xsl:variable name="refentrytitle" select="$refmeta//refentrytitle"/>
  <xsl:variable name="refnamediv" select=".//refnamediv"/>
  <xsl:variable name="refname" select="$refnamediv//refname"/>
  <xsl:variable name="title">
    <xsl:choose>
    <xsl:when test="$refentrytitle">
      <xsl:apply-templates select="$refentrytitle[1]"/>
    </xsl:when>
    <xsl:when test="$refname">
      <xsl:apply-templates select="$refname[1]"/>
    </xsl:when>
    <xsl:otherwise></xsl:otherwise>
  </xsl:choose>
  </xsl:variable>
  <xsl:text>&#10;</xsl:text>
  <xsl:text>%% Refentry &#10;</xsl:text>
  <xsl:text>%% ---------&#10;</xsl:text>
	<xsl:text>\newpage&#10;</xsl:text>

  <xsl:variable name="level">
    <xsl:call-template name="get.sect.level"/>
  </xsl:variable>

  <xsl:choose>
  <xsl:when test="$refentry.numbered = '0'">
    <!-- Unumbered refentry title (but in TOC) -->
    <xsl:call-template name="section.unnumbered">
      <xsl:with-param name="level" select="$level"/>
      <xsl:with-param name="title" select="$title"/>
      <xsl:with-param name="tocdepth" select="$refentry.tocdepth"/>
    </xsl:call-template>
  </xsl:when>
  <xsl:otherwise>
    <!-- Numbered refentry title -->
    <xsl:call-template name="maketitle">
      <xsl:with-param name="level" select="$level"/>
      <xsl:with-param name="title" select="$title"/>
    </xsl:call-template>
    <xsl:apply-templates/>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Select draft mode -->
<xsl:param name="draft.mode">yes</xsl:param>

<!-- Whether to print a Watermak on each page in draft mode -->
<xsl:param name="draft.watermark">0</xsl:param>

<!-- Put the dblatex logo -->
<xsl:param name="doc.publisher.show">1</xsl:param>

<!-- Print the document collaborators -->
<xsl:param name="doc.collab.show">0</xsl:param>

<!-- Specifies the overall document layout -->
<!-- <xsl:param name="doc.layout">coverpage toc frontmatter mainmatter index </xsl:param> -->

<!-- Print the revhistory table -->
<xsl:param name="latex.output.revhistory">0</xsl:param>

<!-- Options/parameters passed to hyperref -->
<xsl:param name="latex.hyperparam">colorlinks,linkcolor=blue,pdfstartview=FitH</xsl:param>

<!-- Output NAME header before refnames -->
<!-- <xsl:param name="refentry.generate.name" select="0"/> -->
<xsl:param name="refentry.generate.name" select="1"/>

</xsl:stylesheet>
