/* utils.c generated by valac 0.20.1, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Pawel Stolowski <pawel.stolowski@canonical.com>
 * based on python code by David Calle <davidc@framli.eu>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



gboolean unity_utils_is_regular_file (const gchar* path);
gboolean unity_utils_is_video (const gchar* path, GError** error);
gboolean unity_utils_is_hidden (const gchar* path, GError** error);
gchar* unity_utils_get_name (const gchar* path, GError** error);
guint unity_utils_gcd (guint a, guint b);


gboolean unity_utils_is_regular_file (const gchar* path) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (_tmp3_) {
		GFile* _tmp4_;
		GFileType _tmp5_ = 0;
		_tmp4_ = file;
		_tmp5_ = g_file_query_file_type (_tmp4_, G_FILE_QUERY_INFO_NONE, NULL);
		result = _tmp5_ == G_FILE_TYPE_REGULAR;
		_g_object_unref0 (file);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (file);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


gboolean unity_utils_is_video (const gchar* path, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (_tmp3_) {
		GFile* _tmp4_;
		GFileType _tmp5_ = 0;
		_tmp4_ = file;
		_tmp5_ = g_file_query_file_type (_tmp4_, G_FILE_QUERY_INFO_NONE, NULL);
		if (_tmp5_ == G_FILE_TYPE_REGULAR) {
			GFile* _tmp6_;
			GFileInfo* _tmp7_ = NULL;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* content_type;
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp6_ = file;
			_tmp7_ = g_file_query_info (_tmp6_, "standard::content-type", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (file);
				return FALSE;
			}
			_tmp9_ = _tmp8_;
			_tmp10_ = g_file_info_get_content_type (_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = _tmp11_;
			_g_object_unref0 (_tmp9_);
			content_type = _tmp12_;
			_tmp13_ = content_type;
			_tmp14_ = string_contains (_tmp13_, "video");
			result = _tmp14_;
			_g_free0 (content_type);
			_g_object_unref0 (file);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (file);
	return result;
}


gboolean unity_utils_is_hidden (const gchar* path, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFileInfo* _tmp2_ = NULL;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return FALSE;
	}
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_info_get_is_hidden (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	result = _tmp6_;
	_g_object_unref0 (file);
	return result;
}


gchar* unity_utils_get_name (const gchar* path, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFileInfo* _tmp2_ = NULL;
	GFileInfo* finfo;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	finfo = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp3_ = g_file_info_get_attribute_as_string (finfo, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME);
	result = _tmp3_;
	_g_object_unref0 (finfo);
	_g_object_unref0 (file);
	return result;
}


guint unity_utils_gcd (guint a, guint b) {
	guint result = 0U;
	guint _tmp0_;
	guint _tmp1_;
	_tmp0_ = a;
	_tmp1_ = b;
	g_return_val_if_fail ((_tmp0_ > ((guint) 0)) && (_tmp1_ > ((guint) 0)), 0U);
	{
		gboolean _tmp2_;
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp3_;
			guint _tmp4_;
			guint _tmp5_;
			_tmp3_ = _tmp2_;
			if (!_tmp3_) {
			}
			_tmp2_ = FALSE;
			_tmp4_ = a;
			_tmp5_ = b;
			if (_tmp4_ > _tmp5_) {
				guint _tmp6_;
				guint _tmp7_;
				guint _tmp8_;
				_tmp6_ = a;
				_tmp7_ = b;
				a = _tmp6_ % _tmp7_;
				_tmp8_ = a;
				if (_tmp8_ == ((guint) 0)) {
					guint _tmp9_;
					guint _tmp10_;
					_tmp9_ = b;
					result = _tmp9_;
					_tmp10_ = result;
					g_warn_if_fail (_tmp10_ > ((guint) 0));
					return result;
				}
			} else {
				guint _tmp11_;
				guint _tmp12_;
				guint _tmp13_;
				_tmp11_ = b;
				_tmp12_ = a;
				b = _tmp11_ % _tmp12_;
				_tmp13_ = b;
				if (_tmp13_ == ((guint) 0)) {
					guint _tmp14_;
					guint _tmp15_;
					_tmp14_ = a;
					result = _tmp14_;
					_tmp15_ = result;
					g_warn_if_fail (_tmp15_ > ((guint) 0));
					return result;
				}
			}
		}
	}
}



