// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_FDIV_2D_TRACE_AARCH64_H_
#define VIXL_SIM_FDIV_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_fdiv_2D[] = {
  0x3ff0000000000000, 0x7ff8000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x3db3fe0000000000, 0x0000000000000000,
  0x0000000000027fc0, 0x0000000000000000,
  0x0000000000027fc0, 0x0000000000000000,
  0x0000000000027fc0, 0x0000000000000000,
  0x0000000000013fe0, 0x0000000000000000,
  0x0000000000013fe0, 0x0000000000000000,
  0x0000000000013fe0, 0x0000000000000000,
  0x000000000000d540, 0x0000000000000000,
  0x0000000000001ffd, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x3df1923e0000000e, 0x0000000000000000,
  0x3db3fe0000000001, 0x0000000000000000,
  0x40f3fe0000000000, 0x7ff8000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0xbdb3fe0000000000, 0x8000000000000000,
  0x8000000000027fc0, 0x8000000000000000,
  0x8000000000027fc0, 0x8000000000000000,
  0x8000000000027fc0, 0x8000000000000000,
  0x8000000000013fe0, 0x8000000000000000,
  0x8000000000013fe0, 0x8000000000000000,
  0x8000000000013fe0, 0x8000000000000000,
  0x800000000000d540, 0x8000000000000000,
  0x8000000000001ffd, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xbdf1923e0000000e, 0x8000000000000000,
  0xbdb3fe0000000001, 0x8000000000000000,
  0x8000000000000000, 0x7ff0000000000000,
  0x7ff8000000000000, 0x3ff0000000000000,
  0x0000000000000000, 0x0020000000000001,
  0x0000000000000000, 0x0020000000000000,
  0x0000000000000000, 0x001ffffffffffffe,
  0x0000000000000000, 0x0010000000000001,
  0x0000000000000000, 0x0010000000000000,
  0x0000000000000000, 0x000fffffffffffff,
  0x0000000000000000, 0x000aaaaaaaaaaaab,
  0x0000000000000000, 0x000199999999999a,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x402c200000000017,
  0x0000000000000000, 0x3ff0000000000001,
  0x0000000000000000, 0x4330000000000000,
  0x0000000000000000, 0xfff0000000000000,
  0x7ff8000000000000, 0xbff0000000000000,
  0x8000000000000000, 0x8020000000000001,
  0x8000000000000000, 0x8020000000000000,
  0x8000000000000000, 0x801ffffffffffffe,
  0x8000000000000000, 0x8010000000000001,
  0x8000000000000000, 0x8010000000000000,
  0x8000000000000000, 0x800fffffffffffff,
  0x8000000000000000, 0x800aaaaaaaaaaaab,
  0x8000000000000000, 0x800199999999999a,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xc02c200000000017,
  0x8000000000000000, 0xbff0000000000001,
  0x8000000000000000, 0xc330000000000000,
  0xc330000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fbfffffffffffff,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x0020000000000001, 0x3fefffffffffffff,
  0x0020000000000000, 0x3feffffffffffffd,
  0x001ffffffffffffe, 0x3fe0000000000000,
  0x0010000000000001, 0x3fdfffffffffffff,
  0x0010000000000000, 0x3fdffffffffffffd,
  0x000fffffffffffff, 0x3fd5555555555555,
  0x000aaaaaaaaaaaab, 0x3fa9999999999999,
  0x000199999999999a, 0x0002000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x402c200000000017, 0x7fc0000000000001,
  0x3ff0000000000001, 0x7ff0000000000000,
  0x4330000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffbfffffffffffff,
  0xbff0000000000000, 0xbff0000000000000,
  0x8020000000000001, 0xbfefffffffffffff,
  0x8020000000000000, 0xbfeffffffffffffd,
  0x801ffffffffffffe, 0xbfe0000000000000,
  0x8010000000000001, 0xbfdfffffffffffff,
  0x8010000000000000, 0xbfdffffffffffffd,
  0x800fffffffffffff, 0xbfd5555555555555,
  0x800aaaaaaaaaaaab, 0xbfa9999999999999,
  0x800199999999999a, 0x8002000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xc02c200000000017, 0xffc0000000000001,
  0xbff0000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fc0000000000000,
  0x7fbfffffffffffff, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fefffffffffffff, 0x3feffffffffffffe,
  0x3feffffffffffffd, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fdffffffffffffe,
  0x3fdffffffffffffd, 0x3fd5555555555555,
  0x3fd5555555555555, 0x3fa999999999999a,
  0x3fa9999999999999, 0x0002000000000000,
  0x0002000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fc0000000000001,
  0x7fc0000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffc0000000000000,
  0xffbfffffffffffff, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfefffffffffffff, 0xbfeffffffffffffe,
  0xbfeffffffffffffd, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfdffffffffffffe,
  0xbfdffffffffffffd, 0xbfd5555555555555,
  0xbfd5555555555555, 0xbfa999999999999a,
  0xbfa9999999999999, 0x8002000000000000,
  0x8002000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffc0000000000001,
  0xffc0000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fc0000000000001,
  0x7fc0000000000000, 0x3ff0000000000002,
  0x3ff0000000000001, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3feffffffffffffe, 0x3fe0000000000002,
  0x3fe0000000000001, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe0000000000000,
  0x3fdffffffffffffe, 0x3fd5555555555557,
  0x3fd5555555555555, 0x3fa999999999999b,
  0x3fa999999999999a, 0x0002000000000000,
  0x0002000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fc0000000000002,
  0x7fc0000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffc0000000000001,
  0xffc0000000000000, 0xbff0000000000002,
  0xbff0000000000001, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfeffffffffffffe, 0xbfe0000000000002,
  0xbfe0000000000001, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe0000000000000,
  0xbfdffffffffffffe, 0xbfd5555555555557,
  0xbfd5555555555555, 0xbfa999999999999b,
  0xbfa999999999999a, 0x8002000000000000,
  0x8002000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffc0000000000002,
  0xffc0000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fcfffffffffffff,
  0x7fc0000000000001, 0x4000000000000000,
  0x3ff0000000000002, 0x3fffffffffffffff,
  0x3ff0000000000001, 0x3ffffffffffffffd,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fe0000000000002, 0x3fefffffffffffff,
  0x3fe0000000000001, 0x3feffffffffffffd,
  0x3fe0000000000000, 0x3fe5555555555555,
  0x3fd5555555555557, 0x3fb9999999999999,
  0x3fa999999999999b, 0x0004000000000000,
  0x0002000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000001,
  0x7fc0000000000002, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffcfffffffffffff,
  0xffc0000000000001, 0xc000000000000000,
  0xbff0000000000002, 0xbfffffffffffffff,
  0xbff0000000000001, 0xbffffffffffffffd,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfe0000000000002, 0xbfefffffffffffff,
  0xbfe0000000000001, 0xbfeffffffffffffd,
  0xbfe0000000000000, 0xbfe5555555555555,
  0xbfd5555555555557, 0xbfb9999999999999,
  0xbfa999999999999b, 0x8004000000000000,
  0x8002000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000001,
  0xffc0000000000002, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000000,
  0x7fcfffffffffffff, 0x4000000000000001,
  0x4000000000000000, 0x4000000000000000,
  0x3fffffffffffffff, 0x3ffffffffffffffe,
  0x3ffffffffffffffd, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fefffffffffffff, 0x3feffffffffffffe,
  0x3feffffffffffffd, 0x3fe5555555555555,
  0x3fe5555555555555, 0x3fb999999999999a,
  0x3fb9999999999999, 0x0004000000000000,
  0x0004000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000001,
  0x7fd0000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000000,
  0xffcfffffffffffff, 0xc000000000000001,
  0xc000000000000000, 0xc000000000000000,
  0xbfffffffffffffff, 0xbffffffffffffffe,
  0xbffffffffffffffd, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfefffffffffffff, 0xbfeffffffffffffe,
  0xbfeffffffffffffd, 0xbfe5555555555555,
  0xbfe5555555555555, 0xbfb999999999999a,
  0xbfb9999999999999, 0x8004000000000000,
  0x8004000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000001,
  0xffd0000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000001,
  0x7fd0000000000000, 0x4000000000000002,
  0x4000000000000001, 0x4000000000000001,
  0x4000000000000000, 0x4000000000000000,
  0x3ffffffffffffffe, 0x3ff0000000000002,
  0x3ff0000000000001, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3feffffffffffffe, 0x3fe5555555555557,
  0x3fe5555555555555, 0x3fb999999999999b,
  0x3fb999999999999a, 0x0004000000000000,
  0x0004000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000002,
  0x7fd0000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000001,
  0xffd0000000000000, 0xc000000000000002,
  0xc000000000000001, 0xc000000000000001,
  0xc000000000000000, 0xc000000000000000,
  0xbffffffffffffffe, 0xbff0000000000002,
  0xbff0000000000001, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfeffffffffffffe, 0xbfe5555555555557,
  0xbfe5555555555555, 0xbfb999999999999b,
  0xbfb999999999999a, 0x8004000000000000,
  0x8004000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000002,
  0xffd0000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd8000000000000,
  0x7fd0000000000001, 0x4008000000000001,
  0x4000000000000002, 0x4008000000000000,
  0x4000000000000001, 0x4007ffffffffffff,
  0x4000000000000000, 0x3ff8000000000001,
  0x3ff0000000000002, 0x3ff8000000000000,
  0x3ff0000000000001, 0x3ff7ffffffffffff,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fe5555555555557, 0x3fc3333333333333,
  0x3fb999999999999b, 0x0006000000000000,
  0x0004000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd8000000000002,
  0x7fd0000000000002, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd8000000000000,
  0xffd0000000000001, 0xc008000000000001,
  0xc000000000000002, 0xc008000000000000,
  0xc000000000000001, 0xc007ffffffffffff,
  0xc000000000000000, 0xbff8000000000001,
  0xbff0000000000002, 0xbff8000000000000,
  0xbff0000000000001, 0xbff7ffffffffffff,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfe5555555555557, 0xbfc3333333333333,
  0xbfb999999999999b, 0x8006000000000000,
  0x8004000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd8000000000002,
  0xffd0000000000002, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7fd8000000000000, 0x4034000000000001,
  0x4008000000000001, 0x4034000000000000,
  0x4008000000000000, 0x4033ffffffffffff,
  0x4007ffffffffffff, 0x4024000000000001,
  0x3ff8000000000001, 0x4024000000000000,
  0x3ff8000000000000, 0x4023ffffffffffff,
  0x3ff7ffffffffffff, 0x401aaaaaaaaaaaab,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fc3333333333333, 0x0024000000000001,
  0x0006000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7fd8000000000002, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xffd8000000000000, 0xc034000000000001,
  0xc008000000000001, 0xc034000000000000,
  0xc008000000000000, 0xc033ffffffffffff,
  0xc007ffffffffffff, 0xc024000000000001,
  0xbff8000000000001, 0xc024000000000000,
  0xbff8000000000000, 0xc023ffffffffffff,
  0xbff7ffffffffffff, 0xc01aaaaaaaaaaaab,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfc3333333333333, 0x8024000000000001,
  0x8006000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xffd8000000000002, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x4034000000000001, 0x7ff0000000000000,
  0x4034000000000000, 0x7ff0000000000000,
  0x4033ffffffffffff, 0x7ff0000000000000,
  0x4024000000000001, 0x7fefffffffffffff,
  0x4024000000000000, 0x7feffffffffffffd,
  0x4023ffffffffffff, 0x7fe5555555555555,
  0x401aaaaaaaaaaaab, 0x7fb9999999999999,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x0024000000000001, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xc034000000000001, 0xfff0000000000000,
  0xc034000000000000, 0xfff0000000000000,
  0xc033ffffffffffff, 0xfff0000000000000,
  0xc024000000000001, 0xffefffffffffffff,
  0xc024000000000000, 0xffeffffffffffffd,
  0xc023ffffffffffff, 0xffe5555555555555,
  0xc01aaaaaaaaaaaab, 0xffb9999999999999,
  0xbff0000000000000, 0xbff0000000000000,
  0x8024000000000001, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7fefffffffffffff, 0x7ff0000000000000,
  0x7feffffffffffffd, 0x7ff0000000000000,
  0x7fe5555555555555, 0x7ff0000000000000,
  0x7fb9999999999999, 0x7ff0000000000000,
  0x3ff0000000000000, 0x7ff8000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xffefffffffffffff, 0xfff0000000000000,
  0xffeffffffffffffd, 0xfff0000000000000,
  0xffe5555555555555, 0xfff0000000000000,
  0xffb9999999999999, 0xfff0000000000000,
  0xbff0000000000000, 0x7ff8000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0x7ff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0xfff0000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0x7ff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0x7ff923456789abcd, 0xfff8000000000000,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0x7ff923456789abcd, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x3fb23456789abcd0,
  0x7ff0000000000000, 0x0002468acf13579a,
  0x7ff0000000000000, 0x0002468acf13579a,
  0x7ff0000000000000, 0x0002468acf13579a,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x0000c22e45067289,
  0x7ff0000000000000, 0x00001d208a5a912e,
  0x7ff0000000000000, 0x0000000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x7ff8000000000000, 0x3ff0000000000000,
  0x7ff0000000000000, 0x3fb23456789abcd1,
  0x7ff0000000000000, 0x42f23456789abcd0,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xbfb23456789abcd0,
  0xfff0000000000000, 0x8002468acf13579a,
  0xfff0000000000000, 0x8002468acf13579a,
  0xfff0000000000000, 0x8002468acf13579a,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x8000c22e45067289,
  0xfff0000000000000, 0x80001d208a5a912e,
  0xfff0000000000000, 0x8000000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0x7ff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x7ff8000000000000, 0xbff0000000000000,
  0xfff0000000000000, 0xbfb23456789abcd1,
  0xfff0000000000000, 0xc2f23456789abcd0,
  0xc2f23456789abcd0, 0x7ff0000000000000,
  0x7ff0000000000000, 0x3feffffffffffffe,
  0x3fb23456789abcd0, 0x001fffffffffffff,
  0x0002468acf13579a, 0x001ffffffffffffe,
  0x0002468acf13579a, 0x001ffffffffffffc,
  0x0002468acf13579a, 0x000fffffffffffff,
  0x000123456789abcd, 0x000fffffffffffff,
  0x000123456789abcd, 0x000ffffffffffffe,
  0x000123456789abcd, 0x000aaaaaaaaaaaaa,
  0x0000c22e45067289, 0x000199999999999a,
  0x00001d208a5a912e, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x402c200000000015,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fb23456789abcd1, 0x432ffffffffffffe,
  0x42f23456789abcd0, 0xfff0000000000000,
  0xfff0000000000000, 0xbfeffffffffffffe,
  0xbfb23456789abcd0, 0x801fffffffffffff,
  0x8002468acf13579a, 0x801ffffffffffffe,
  0x8002468acf13579a, 0x801ffffffffffffc,
  0x8002468acf13579a, 0x800fffffffffffff,
  0x800123456789abcd, 0x800fffffffffffff,
  0x800123456789abcd, 0x800ffffffffffffe,
  0x800123456789abcd, 0x800aaaaaaaaaaaaa,
  0x8000c22e45067289, 0x800199999999999a,
  0x80001d208a5a912e, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xc02c200000000015,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfb23456789abcd1, 0xc32ffffffffffffe,
  0xc32ffffffffffffe, 0x7ff0000000000000,
  0x7ff0000000000000, 0x3cb0000000000000,
  0x3feffffffffffffe, 0x0000000000000002,
  0x001fffffffffffff, 0x0000000000000002,
  0x001ffffffffffffe, 0x0000000000000002,
  0x001ffffffffffffc, 0x0000000000000001,
  0x000fffffffffffff, 0x0000000000000001,
  0x000fffffffffffff, 0x0000000000000001,
  0x000ffffffffffffe, 0x0000000000000001,
  0x000aaaaaaaaaaaaa, 0x0000000000000000,
  0x000199999999999a, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x3cec200000000017,
  0x402c200000000015, 0x3cb0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x432ffffffffffffe, 0xfff0000000000000,
  0xfff0000000000000, 0xbcb0000000000000,
  0xbfeffffffffffffe, 0x8000000000000002,
  0x801fffffffffffff, 0x8000000000000002,
  0x801ffffffffffffe, 0x8000000000000002,
  0x801ffffffffffffc, 0x8000000000000001,
  0x800fffffffffffff, 0x8000000000000001,
  0x800fffffffffffff, 0x8000000000000001,
  0x800ffffffffffffe, 0x8000000000000001,
  0x800aaaaaaaaaaaaa, 0x8000000000000000,
  0x800199999999999a, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xbcec200000000017,
  0xc02c200000000015, 0xbcb0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xbff0000000000000, 0x7ff8000000000000,
  0x7ff0000000000000, 0x8000000000000000,
  0x3cb0000000000000, 0x8000000000000000,
  0x0000000000000002, 0x8000000000000000,
  0x0000000000000002, 0x8000000000000000,
  0x0000000000000002, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x3cec200000000017, 0x8000000000000000,
  0x3cb0000000000001, 0x8000000000000000,
  0x3ff0000000000000, 0x7ff8000000000000,
  0xfff0000000000000, 0x0000000000000000,
  0xbcb0000000000000, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xbcec200000000017, 0x0000000000000000,
  0xbcb0000000000001, 0x0000000000000000,
  0x0000000000000000, 0xfff0000000000000,
  0x7ff8000000000000, 0xbff0000000000000,
  0x8000000000000000, 0x8020000000000001,
  0x8000000000000000, 0x8020000000000000,
  0x8000000000000000, 0x801ffffffffffffe,
  0x8000000000000000, 0x8010000000000001,
  0x8000000000000000, 0x8010000000000000,
  0x8000000000000000, 0x800fffffffffffff,
  0x8000000000000000, 0x800aaaaaaaaaaaab,
  0x8000000000000000, 0x800199999999999a,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xc02c200000000017,
  0x8000000000000000, 0xbff0000000000001,
  0x8000000000000000, 0xc330000000000000,
  0x8000000000000000, 0x7ff0000000000000,
  0x7ff8000000000000, 0x3ff0000000000000,
  0x0000000000000000, 0x0020000000000001,
  0x0000000000000000, 0x0020000000000000,
  0x0000000000000000, 0x001ffffffffffffe,
  0x0000000000000000, 0x0010000000000001,
  0x0000000000000000, 0x0010000000000000,
  0x0000000000000000, 0x000fffffffffffff,
  0x0000000000000000, 0x000aaaaaaaaaaaab,
  0x0000000000000000, 0x000199999999999a,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x402c200000000017,
  0x0000000000000000, 0x3ff0000000000001,
  0x0000000000000000, 0x4330000000000000,
  0x4330000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffbfffffffffffff,
  0xbff0000000000000, 0xbff0000000000000,
  0x8020000000000001, 0xbfefffffffffffff,
  0x8020000000000000, 0xbfeffffffffffffd,
  0x801ffffffffffffe, 0xbfe0000000000000,
  0x8010000000000001, 0xbfdfffffffffffff,
  0x8010000000000000, 0xbfdffffffffffffd,
  0x800fffffffffffff, 0xbfd5555555555555,
  0x800aaaaaaaaaaaab, 0xbfa9999999999999,
  0x800199999999999a, 0x8002000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xc02c200000000017, 0xffc0000000000001,
  0xbff0000000000001, 0xfff0000000000000,
  0xc330000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fbfffffffffffff,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x0020000000000001, 0x3fefffffffffffff,
  0x0020000000000000, 0x3feffffffffffffd,
  0x001ffffffffffffe, 0x3fe0000000000000,
  0x0010000000000001, 0x3fdfffffffffffff,
  0x0010000000000000, 0x3fdffffffffffffd,
  0x000fffffffffffff, 0x3fd5555555555555,
  0x000aaaaaaaaaaaab, 0x3fa9999999999999,
  0x000199999999999a, 0x0002000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x402c200000000017, 0x7fc0000000000001,
  0x3ff0000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffc0000000000000,
  0xffbfffffffffffff, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfefffffffffffff, 0xbfeffffffffffffe,
  0xbfeffffffffffffd, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe0000000000000,
  0xbfdfffffffffffff, 0xbfdffffffffffffe,
  0xbfdffffffffffffd, 0xbfd5555555555555,
  0xbfd5555555555555, 0xbfa999999999999a,
  0xbfa9999999999999, 0x8002000000000000,
  0x8002000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffc0000000000001,
  0xffc0000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fc0000000000000,
  0x7fbfffffffffffff, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fefffffffffffff, 0x3feffffffffffffe,
  0x3feffffffffffffd, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe0000000000000,
  0x3fdfffffffffffff, 0x3fdffffffffffffe,
  0x3fdffffffffffffd, 0x3fd5555555555555,
  0x3fd5555555555555, 0x3fa999999999999a,
  0x3fa9999999999999, 0x0002000000000000,
  0x0002000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fc0000000000001,
  0x7fc0000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffc0000000000001,
  0xffc0000000000000, 0xbff0000000000002,
  0xbff0000000000001, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfeffffffffffffe, 0xbfe0000000000002,
  0xbfe0000000000001, 0xbfe0000000000001,
  0xbfe0000000000000, 0xbfe0000000000000,
  0xbfdffffffffffffe, 0xbfd5555555555557,
  0xbfd5555555555555, 0xbfa999999999999b,
  0xbfa999999999999a, 0x8002000000000000,
  0x8002000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffc0000000000002,
  0xffc0000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fc0000000000001,
  0x7fc0000000000000, 0x3ff0000000000002,
  0x3ff0000000000001, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3feffffffffffffe, 0x3fe0000000000002,
  0x3fe0000000000001, 0x3fe0000000000001,
  0x3fe0000000000000, 0x3fe0000000000000,
  0x3fdffffffffffffe, 0x3fd5555555555557,
  0x3fd5555555555555, 0x3fa999999999999b,
  0x3fa999999999999a, 0x0002000000000000,
  0x0002000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fc0000000000002,
  0x7fc0000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffcfffffffffffff,
  0xffc0000000000001, 0xc000000000000000,
  0xbff0000000000002, 0xbfffffffffffffff,
  0xbff0000000000001, 0xbffffffffffffffd,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfe0000000000002, 0xbfefffffffffffff,
  0xbfe0000000000001, 0xbfeffffffffffffd,
  0xbfe0000000000000, 0xbfe5555555555555,
  0xbfd5555555555557, 0xbfb9999999999999,
  0xbfa999999999999b, 0x8004000000000000,
  0x8002000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000001,
  0xffc0000000000002, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fcfffffffffffff,
  0x7fc0000000000001, 0x4000000000000000,
  0x3ff0000000000002, 0x3fffffffffffffff,
  0x3ff0000000000001, 0x3ffffffffffffffd,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fe0000000000002, 0x3fefffffffffffff,
  0x3fe0000000000001, 0x3feffffffffffffd,
  0x3fe0000000000000, 0x3fe5555555555555,
  0x3fd5555555555557, 0x3fb9999999999999,
  0x3fa999999999999b, 0x0004000000000000,
  0x0002000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000001,
  0x7fc0000000000002, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000000,
  0xffcfffffffffffff, 0xc000000000000001,
  0xc000000000000000, 0xc000000000000000,
  0xbfffffffffffffff, 0xbffffffffffffffe,
  0xbffffffffffffffd, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfefffffffffffff, 0xbfeffffffffffffe,
  0xbfeffffffffffffd, 0xbfe5555555555555,
  0xbfe5555555555555, 0xbfb999999999999a,
  0xbfb9999999999999, 0x8004000000000000,
  0x8004000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000001,
  0xffd0000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000000,
  0x7fcfffffffffffff, 0x4000000000000001,
  0x4000000000000000, 0x4000000000000000,
  0x3fffffffffffffff, 0x3ffffffffffffffe,
  0x3ffffffffffffffd, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fefffffffffffff, 0x3feffffffffffffe,
  0x3feffffffffffffd, 0x3fe5555555555555,
  0x3fe5555555555555, 0x3fb999999999999a,
  0x3fb9999999999999, 0x0004000000000000,
  0x0004000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000001,
  0x7fd0000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000001,
  0xffd0000000000000, 0xc000000000000002,
  0xc000000000000001, 0xc000000000000001,
  0xc000000000000000, 0xc000000000000000,
  0xbffffffffffffffe, 0xbff0000000000002,
  0xbff0000000000001, 0xbff0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfeffffffffffffe, 0xbfe5555555555557,
  0xbfe5555555555555, 0xbfb999999999999b,
  0xbfb999999999999a, 0x8004000000000000,
  0x8004000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd0000000000002,
  0xffd0000000000001, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000001,
  0x7fd0000000000000, 0x4000000000000002,
  0x4000000000000001, 0x4000000000000001,
  0x4000000000000000, 0x4000000000000000,
  0x3ffffffffffffffe, 0x3ff0000000000002,
  0x3ff0000000000001, 0x3ff0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3feffffffffffffe, 0x3fe5555555555557,
  0x3fe5555555555555, 0x3fb999999999999b,
  0x3fb999999999999a, 0x0004000000000000,
  0x0004000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd0000000000002,
  0x7fd0000000000001, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd8000000000000,
  0xffd0000000000001, 0xc008000000000001,
  0xc000000000000002, 0xc008000000000000,
  0xc000000000000001, 0xc007ffffffffffff,
  0xc000000000000000, 0xbff8000000000001,
  0xbff0000000000002, 0xbff8000000000000,
  0xbff0000000000001, 0xbff7ffffffffffff,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfe5555555555557, 0xbfc3333333333333,
  0xbfb999999999999b, 0x8006000000000000,
  0x8004000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xffd8000000000002,
  0xffd0000000000002, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd8000000000000,
  0x7fd0000000000001, 0x4008000000000001,
  0x4000000000000002, 0x4008000000000000,
  0x4000000000000001, 0x4007ffffffffffff,
  0x4000000000000000, 0x3ff8000000000001,
  0x3ff0000000000002, 0x3ff8000000000000,
  0x3ff0000000000001, 0x3ff7ffffffffffff,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fe5555555555557, 0x3fc3333333333333,
  0x3fb999999999999b, 0x0006000000000000,
  0x0004000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7fd8000000000002,
  0x7fd0000000000002, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xffd8000000000000, 0xc034000000000001,
  0xc008000000000001, 0xc034000000000000,
  0xc008000000000000, 0xc033ffffffffffff,
  0xc007ffffffffffff, 0xc024000000000001,
  0xbff8000000000001, 0xc024000000000000,
  0xbff8000000000000, 0xc023ffffffffffff,
  0xbff7ffffffffffff, 0xc01aaaaaaaaaaaab,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfc3333333333333, 0x8024000000000001,
  0x8006000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xffd8000000000002, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7fd8000000000000, 0x4034000000000001,
  0x4008000000000001, 0x4034000000000000,
  0x4008000000000000, 0x4033ffffffffffff,
  0x4007ffffffffffff, 0x4024000000000001,
  0x3ff8000000000001, 0x4024000000000000,
  0x3ff8000000000000, 0x4023ffffffffffff,
  0x3ff7ffffffffffff, 0x401aaaaaaaaaaaab,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fc3333333333333, 0x0024000000000001,
  0x0006000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7fd8000000000002, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xc034000000000001, 0xfff0000000000000,
  0xc034000000000000, 0xfff0000000000000,
  0xc033ffffffffffff, 0xfff0000000000000,
  0xc024000000000001, 0xffefffffffffffff,
  0xc024000000000000, 0xffeffffffffffffd,
  0xc023ffffffffffff, 0xffe5555555555555,
  0xc01aaaaaaaaaaaab, 0xffb9999999999999,
  0xbff0000000000000, 0xbff0000000000000,
  0x8024000000000001, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x4034000000000001, 0x7ff0000000000000,
  0x4034000000000000, 0x7ff0000000000000,
  0x4033ffffffffffff, 0x7ff0000000000000,
  0x4024000000000001, 0x7fefffffffffffff,
  0x4024000000000000, 0x7feffffffffffffd,
  0x4023ffffffffffff, 0x7fe5555555555555,
  0x401aaaaaaaaaaaab, 0x7fb9999999999999,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x0024000000000001, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xffefffffffffffff, 0xfff0000000000000,
  0xffeffffffffffffd, 0xfff0000000000000,
  0xffe5555555555555, 0xfff0000000000000,
  0xffb9999999999999, 0xfff0000000000000,
  0xbff0000000000000, 0x7ff8000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x8000000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7fefffffffffffff, 0x7ff0000000000000,
  0x7feffffffffffffd, 0x7ff0000000000000,
  0x7fe5555555555555, 0x7ff0000000000000,
  0x7fb9999999999999, 0x7ff0000000000000,
  0x3ff0000000000000, 0x7ff8000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0x0000000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0x7ff8000000000000, 0xfff923456789abcd,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0x7ff8000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0xfff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff923456789abcd,
  0x7ff8000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0x7ff0000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0x7ff923456789abcd, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff923456789abcd, 0x7ff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0xfff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff923456789abcd, 0xfff923456789abcd,
  0xfff923456789abcd, 0x7ff8000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0xfff923456789abcd, 0x7ff0000000000000,
  0x7ff0000000000000, 0xfff0000000000000,
  0xfff0000000000000, 0xbfb23456789abcd0,
  0xfff0000000000000, 0x8002468acf13579a,
  0xfff0000000000000, 0x8002468acf13579a,
  0xfff0000000000000, 0x8002468acf13579a,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x800123456789abcd,
  0xfff0000000000000, 0x8000c22e45067289,
  0xfff0000000000000, 0x80001d208a5a912e,
  0xfff0000000000000, 0x8000000000000000,
  0xfff0000000000000, 0x8000000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x7ff8000000000000, 0xbff0000000000000,
  0xfff0000000000000, 0xbfb23456789abcd1,
  0xfff0000000000000, 0xc2f23456789abcd0,
  0xfff0000000000000, 0x7ff0000000000000,
  0x7ff0000000000000, 0x3fb23456789abcd0,
  0x7ff0000000000000, 0x0002468acf13579a,
  0x7ff0000000000000, 0x0002468acf13579a,
  0x7ff0000000000000, 0x0002468acf13579a,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x000123456789abcd,
  0x7ff0000000000000, 0x0000c22e45067289,
  0x7ff0000000000000, 0x00001d208a5a912e,
  0x7ff0000000000000, 0x0000000000000000,
  0x7ff0000000000000, 0x0000000000000000,
  0x7ff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x7ff8000000000000, 0x3ff0000000000000,
  0x7ff0000000000000, 0x3fb23456789abcd1,
  0x7ff0000000000000, 0x42f23456789abcd0,
  0x42f23456789abcd0, 0xfff0000000000000,
  0xfff0000000000000, 0xbfeffffffffffffe,
  0xbfb23456789abcd0, 0x801fffffffffffff,
  0x8002468acf13579a, 0x801ffffffffffffe,
  0x8002468acf13579a, 0x801ffffffffffffc,
  0x8002468acf13579a, 0x800fffffffffffff,
  0x800123456789abcd, 0x800fffffffffffff,
  0x800123456789abcd, 0x800ffffffffffffe,
  0x800123456789abcd, 0x800aaaaaaaaaaaaa,
  0x8000c22e45067289, 0x800199999999999a,
  0x80001d208a5a912e, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xc02c200000000015,
  0xbff0000000000000, 0xbff0000000000000,
  0xbfb23456789abcd1, 0xc32ffffffffffffe,
  0xc2f23456789abcd0, 0x7ff0000000000000,
  0x7ff0000000000000, 0x3feffffffffffffe,
  0x3fb23456789abcd0, 0x001fffffffffffff,
  0x0002468acf13579a, 0x001ffffffffffffe,
  0x0002468acf13579a, 0x001ffffffffffffc,
  0x0002468acf13579a, 0x000fffffffffffff,
  0x000123456789abcd, 0x000fffffffffffff,
  0x000123456789abcd, 0x000ffffffffffffe,
  0x000123456789abcd, 0x000aaaaaaaaaaaaa,
  0x0000c22e45067289, 0x000199999999999a,
  0x00001d208a5a912e, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x402c200000000015,
  0x3ff0000000000000, 0x3ff0000000000000,
  0x3fb23456789abcd1, 0x432ffffffffffffe,
  0x432ffffffffffffe, 0xfff0000000000000,
  0xfff0000000000000, 0xbcb0000000000000,
  0xbfeffffffffffffe, 0x8000000000000002,
  0x801fffffffffffff, 0x8000000000000002,
  0x801ffffffffffffe, 0x8000000000000002,
  0x801ffffffffffffc, 0x8000000000000001,
  0x800fffffffffffff, 0x8000000000000001,
  0x800fffffffffffff, 0x8000000000000001,
  0x800ffffffffffffe, 0x8000000000000001,
  0x800aaaaaaaaaaaaa, 0x8000000000000000,
  0x800199999999999a, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x7ff8000000000000,
  0x7ff8000000000000, 0x7ff923456789abcd,
  0x7ff923456789abcd, 0x8000000000000000,
  0x8000000000000000, 0xbcec200000000017,
  0xc02c200000000015, 0xbcb0000000000001,
  0xbff0000000000000, 0xbff0000000000000,
  0xc32ffffffffffffe, 0x7ff0000000000000,
  0x7ff0000000000000, 0x3cb0000000000000,
  0x3feffffffffffffe, 0x0000000000000002,
  0x001fffffffffffff, 0x0000000000000002,
  0x001ffffffffffffe, 0x0000000000000002,
  0x001ffffffffffffc, 0x0000000000000001,
  0x000fffffffffffff, 0x0000000000000001,
  0x000fffffffffffff, 0x0000000000000001,
  0x000ffffffffffffe, 0x0000000000000001,
  0x000aaaaaaaaaaaaa, 0x0000000000000000,
  0x000199999999999a, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0xfff8000000000000,
  0xfff8000000000000, 0xfff923456789abcd,
  0xfff923456789abcd, 0x0000000000000000,
  0x0000000000000000, 0x3cec200000000017,
  0x402c200000000015, 0x3cb0000000000001,
  0x3ff0000000000000, 0x3ff0000000000000,
};
const unsigned kExpectedCount_NEON_fdiv_2D = 1444;

#endif  // VIXL_SIM_FDIV_2D_TRACE_AARCH64_H_
