/*
 * NodeLineSet.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_LINESET_H
#define _NODE_LINESET_H

#ifndef _GEOMETRY_NODE_H
#include "GeometryNode.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoLineSet : public GeometryProto {
public:
                    ProtoLineSet(Scene *scene);
    virtual Node   *create(Scene *scene);

    virtual int     getType() const { return X3D_LINE_SET; }
    virtual int     getNodeClass() const 
                       { return LINE_SET_NODE | GEOMETRY_NODE; }

    FieldIndex attrib;
    FieldIndex color;
    FieldIndex coord;
    FieldIndex fogCoord;
    FieldIndex vertexCount;
};

class NodeLineSet : public GeometryNode {
public:
                    NodeLineSet(Scene *scene, Proto *proto);

    virtual const char* getComponentName(void) const 
                           { return "Rendering"; }
    virtual int         getComponentLevel(void) const { return 1; }

    virtual Node   *copy() const { return new NodeLineSet(*this); }

    virtual void    draw();

    virtual bool    isInvalidChildNode(void) { return true; }
    virtual bool    hasBoundingBox(void)     { return true; }
    virtual Vec3f   getMinBoundingBox(void);
    virtual Vec3f   getMaxBoundingBox(void);
    virtual void    flip(int index);
    virtual void    swap(int fromTo);

    Node           *toPointSet(void);

    virtual bool    canWriteAc3d() { return true; }
    virtual int     writeAc3d(int filedes, int indent);

    virtual bool    canWriteLdrawDat() { return true; }
    virtual int     writeLdrawDat(int filedes, int indent);

    fieldMacros(MFNode,  attrib,      ProtoLineSet)
    fieldMacros(SFNode,  color,       ProtoLineSet)
    fieldMacros(SFNode,  coord,       ProtoLineSet)
    fieldMacros(SFNode,  fogCoord,    ProtoLineSet)
    fieldMacros(MFInt32, vertexCount, ProtoLineSet)

    void            lineDraw();
};


#endif // _NODE_LINESET_H
