/**
 * FCoordSyst.java
 *
 * Created on Jul 3, 2006
 */
package maths;


/**
 * Cette classe implemente <CODE>CoordSyst</CODE>.
 *
 * @author Nicolae
 */
public class FCoordSyst implements CoordSyst {
	
	private int wd;
	private int ht;
	private double re1;
	private double im1;
	private double re2;
	private double im2;
	private double rat;

	/**
	 * Constructeur standard.
	 */
	public FCoordSyst() {
		wd = 1;
		ht = 1;
		re1 = 0;
		im1 = 0;
		re2 = 0;
		im2 = 0;
		rat = 1;
	}
	
	public void setPix(int w, int h) {
		wd = w;
		ht = h;
	}

	public void setCoord(double r1, double i1, double r2, double i2) {
		re1 = Math.min(r1, r2);
		im1 = Math.min(i1, i2);
		re2 = Math.max(r1, r2);
		im2 = Math.max(i1, i2);
		
		if(rat > 0)
			rat = (r2 - r1) / (i2 - i1);
	}

	public double getRe(int x) {
		return re1 + ((re2 - re1) * (x + 0.5)) / wd;
	}

	public double getIm(int y) {
		return im2 + ((im1 - im2) * (y + 0.5)) / ht;
	}

	public int getX(double re) {
		return (int)(((re - re1) / (re2 - re1)) * wd);
	}

	public int getY(double im) {
		return (int)(((im - im2) / (im1 - im2)) * ht);
	}

	public int getWidth() {
		return wd;
	}
	
	public int getHeigth() {
		return ht;
	}

	public boolean isValid() {
		return wd > 1 && ht > 1;
	}
	
	public void setRatio(double rat) {
		this.rat = rat;
	}
	
	public double getRatio() {
		return rat;
	}
	
	public double getRe1() {
		return re1;
	}
	
	public double getRe2() {
		return re2;
	}
	
	public double getIm1() {
		return im1;
	}
	
	public double getIm2() {
		return im2;
	}
	
	public void moveCenter(double re, double im) {
		double dx = re - (re1 + re2) / 2;
		double dy = im - (im1 + im2) / 2;
		
		re1 += dx;
		re2 += dx;
		im1 += dy;
		im2 += dy;
	}
	
	public void zoom(double zm) {
		if(zm <= 0)
			return;

		double cx = (re1 + re2) / 2;
		double cy = (im1 + im2) / 2;

		re1 = cx - (cx - re1) / zm;
		re2 = cx + (re2 - cx) / zm;
		im1 = cy - (cy - im1) / zm;
		im2 = cy + (im2 - cy) / zm;
	}
			
	public CoordSyst copie() {
		FCoordSyst cl = new FCoordSyst();
		cl.setPix(wd, ht);
		cl.setCoord(re1, im1, re2, im2);
		cl.setRatio(rat);
		
		return cl;
	}
}
