/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.Circle3Object;
import rene.zirkel.objects.PointObject;

public class Circle3Constructor
extends ObjectConstructor {
    PointObject P1 = null;
    PointObject P2 = null;
    PointObject P3 = null;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        if (this.P1 == null) {
            this.P1 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zirkelCanvas.repaint();
            }
            this.showStatus(zirkelCanvas);
        } else if (this.P2 == null) {
            this.P2 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P2 != null && this.P2 != this.P1) {
                this.P2.setSelected(true);
                zirkelCanvas.repaint();
            }
            this.showStatus(zirkelCanvas);
        } else {
            this.P3 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P3 != null) {
                Circle3Object circle3Object = new Circle3Object(zirkelCanvas.getConstruction(), this.P1, this.P2, this.P3);
                zirkelCanvas.addObject(circle3Object);
                circle3Object.setDefaults();
                circle3Object.updateCircleDep();
                this.P3 = null;
                this.P2 = null;
                this.P1 = null;
                zirkelCanvas.clearSelected();
                this.showStatus(zirkelCanvas);
            }
        }
    }

    public boolean waitForLastPoint() {
        return this.P1 != null && this.P2 != null;
    }

    public void finishConstruction(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        this.P3 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
        if (this.P3 != null) {
            Circle3Object circle3Object = new Circle3Object(zirkelCanvas.getConstruction(), this.P1, this.P2, this.P3);
            zirkelCanvas.addObject(circle3Object);
            circle3Object.setDefaults();
            zirkelCanvas.validate();
            zirkelCanvas.repaint();
            this.P3 = null;
        }
    }

    public PointObject select(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return zirkelCanvas.selectCreatePoint(n, n2);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        if (zirkelCanvas.Visual) {
            this.P3 = null;
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zirkelCanvas);
        } else {
            zirkelCanvas.setPrompt(Zirkel.name("prompt.circle3"));
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.circle3.first", "Circle: Choose the first radius point!"));
        } else if (this.P2 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.circle3.second", "Circle: Choose the second radius point!"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.circle3.midpoint", "Circle: Choose the midpoint!"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Circle3")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!(xmlTag.hasParam("midpoint") && xmlTag.hasParam("from") && xmlTag.hasParam("to"))) {
            throw new ConstructionException("Circle3 parameters missing!");
        }
        try {
            PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("midpoint"));
            PointObject pointObject2 = (PointObject)construction.find(xmlTag.getValue("from"));
            PointObject pointObject3 = (PointObject)construction.find(xmlTag.getValue("to"));
            Circle3Object circle3Object = new Circle3Object(construction, pointObject2, pointObject3, pointObject);
            if (xmlTag.hasParam("partial")) {
                circle3Object.setPartial(true);
            }
            if (xmlTag.hasParam("start") && xmlTag.hasParam("end")) {
                circle3Object.setRange(xmlTag.getValue("start"), xmlTag.getValue("end"));
            }
            this.setName(xmlTag, circle3Object);
            this.set(xmlTree, circle3Object);
            construction.add(circle3Object);
            this.setConditionals(xmlTree, construction, circle3Object);
        }
        catch (ConstructionException constructionException) {
            throw constructionException;
        }
        catch (Exception exception) {
            throw new ConstructionException("Circle3 parameters illegal!");
        }
        return true;
    }
}

