//-----------------------------------------------------------------------------
//  Copyright (C) 2002-2015 Thomas S. Ullrich
//
//  This file is part of "xyscan".
//
//  This file may be used under the terms of the GNU General Public License.
//  This project is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License.
//  
//  Author: Thomas S. Ullrich
//  Last update: March 28, 2014
//-----------------------------------------------------------------------------
#ifndef xyscanStateMachine_h
#define xyscanStateMachine_h

class xyscanStateMachine {
    
public:
    xyscanStateMachine();
    
    bool allowKeyLeft();
    bool allowKeyRight();
    bool allowKeyUp();
    bool allowKeyDown();
    bool allowXYScan();
    bool doPrepareErrorXScan();
    bool doPrepareErrorYScan();
    bool allowScanXLeft();
    bool allowScanXRight();
    bool allowScanYLower();
    bool allowScanYUpper();
    bool removeErrorXScanSetup();
    bool removeErrorYScanSetup();
    bool enableSettingsMenu();
    bool disableSettingsMenu();
    bool allowWriteXY();
    bool allowWriteXYErrorX();
    bool allowWriteXYErrorY();
    bool allowWriteXYErrorXErrorY();
    
    void setScanErrorXSelected(bool);
    void setScanErrorYSelected(bool);
    void setErrorXScanPrepared(bool);
    void setErrorYScanPrepared(bool);
    void setXYScanDone(bool);
    void setScanXLeftDone(bool);
    void setScanXRightDone(bool);
    void setScanYLowerDone(bool);
    void setScanYUpperDone(bool);
    void setErrorXScanSetupRemoved(bool);
    void setErrorYScanSetupRemoved(bool);
    void setDataWritten(bool);
    
private:
    bool mScanErrorXSelected;
    bool mScanErrorYSelected;
    bool mErrorXScanPrepared;
    bool mErrorYScanPrepared;
    bool mXYScanDone;
    bool mScanXLeftDone;
    bool mScanXRightDone;
    bool mScanYLowerDone;
    bool mScanYUpperDone;
    bool mErrorXScanSetupRemoved;
    bool mErrorYScanSetupRemoved;
    bool mDataWritten;
    
private:
    void clear();
};
#endif


