package ONVIF::Media::Types::NetworkCapabilitiesExtension;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Dot11Configuration_of :ATTR(:get<Dot11Configuration>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Dot11Configuration
        Extension

    ) ],
    {
        'Dot11Configuration' => \%Dot11Configuration_of,
        'Extension' => \%Extension_of,
    },
    {
        'Dot11Configuration' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Extension' => 'ONVIF::Media::Types::NetworkCapabilitiesExtension2',
    },
    {

        'Dot11Configuration' => 'Dot11Configuration',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::NetworkCapabilitiesExtension

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
NetworkCapabilitiesExtension from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Dot11Configuration


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::NetworkCapabilitiesExtension
   Dot11Configuration =>  $some_value, # boolean
   Extension =>  { # ONVIF::Media::Types::NetworkCapabilitiesExtension2
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

