/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;

public class IteratorResourceClosing<T>
implements Iterator<T>,
Closeable {
    private final Iterator<T> iter;
    private final Object resource;
    private boolean finished;

    public IteratorResourceClosing(Iterator<T> iter, Closeable resource) {
        this.iter = iter;
        this.resource = resource;
        this.finished = false;
    }

    public IteratorResourceClosing(Iterator<T> iter, java.io.Closeable resource) {
        this.iter = iter;
        this.resource = resource;
        this.finished = false;
    }

    private void checkFinished() {
        if (this.finished) {
            throw new AtlasException("IteratorResourceClosing is closed, no further operations can be performed on it.");
        }
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        boolean toReturn = this.iter.hasNext();
        if (!toReturn) {
            this.close();
        }
        return toReturn;
    }

    @Override
    public T next() {
        this.checkFinished();
        return this.iter.next();
    }

    @Override
    public void remove() {
        this.checkFinished();
        this.iter.remove();
    }

    @Override
    public void close() {
        if (!this.finished) {
            Iter.close(this.iter);
            if (null != this.resource) {
                if (this.resource instanceof Closeable) {
                    ((Closeable)this.resource).close();
                } else {
                    IO.close((java.io.Closeable)this.resource);
                }
            }
            this.finished = true;
        }
    }
}

