// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Runtime.CompilerServices;
using System.Numerics;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.X86;
using Xunit;

// Generated by Fuzzlyn v2.1 on 2024-07-28 20:12:47
// Run on X64 Linux
// Seed: 10470319919864604789-vectort,vector128,vector256,x86aes,x86avx,x86avx2,x86avx512bw,x86avx512bwvl,x86avx512cd,x86avx512cdvl,x86avx512dq,x86avx512dqvl,x86avx512f,x86avx512fvl,x86avx512fx64,x86bmi1,x86bmi1x64,x86bmi2,x86bmi2x64,x86fma,x86lzcnt,x86lzcntx64,x86pclmulqdq,x86popcnt,x86popcntx64,x86sse,x86ssex64,x86sse2,x86sse2x64,x86sse3,x86sse41,x86sse41x64,x86sse42,x86sse42x64,x86ssse3,x86x86base
// Reduced from 21.8 KiB to 0.7 KiB in 00:01:56
// Hits JIT assert in Release:
// Assertion failed 'IS_ALIGNED(addr, byteSize)' in 'Program:Main(Fuzzlyn.ExecutionServer.IRuntime)' during 'Emit code' (IL size 31; hash 0xade6b36b; FullOpts)
//
//     File: /__w/1/s/src/coreclr/jit/emitxarch.cpp Line: 14543
//

public class Runtime_105624
{
    [Fact]
    public static void TestEntryPoint()
    {
        if (Avx512F.IsSupported)
        {
            var vr8 = Vector128.CreateScalar(4294967294U);
            var vr7 = Avx512F.VL.ConvertToVector256Double(vr8);

            var vr10 = Vector128.CreateScalar(4294967295U);
            var vr9 = Avx512F.VL.ConvertToVector256Double(vr10);

            var res = vr7 + vr9;
            Assert.Equal(Vector256.CreateScalar(8589934589.0), res);
        }
    }
}
