// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Runtime.CompilerServices;
using System.Numerics;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.X86;
using Xunit;

// Generated by Fuzzlyn v2.2 on 2024-08-17 17:40:06
// Run on X86 Windows
// Seed: 1343518557351353159-vectort,vector128,vector256,vector512,x86aes,x86avx,x86avx2,x86avx512bw,x86avx512bwvl,x86avx512cd,x86avx512cdvl,x86avx512dq,x86avx512dqvl,x86avx512f,x86avx512fvl,x86avx512vbmi,x86avx512vbmivl,x86bmi1,x86bmi2,x86fma,x86lzcnt,x86pclmulqdq,x86popcnt,x86sse,x86sse2,x86sse3,x86sse41,x86sse42,x86ssse3,x86x86base
// Reduced from 171.2 KiB to 0.6 KiB in 00:06:37
// Debug: Outputs <4292870144, 0, 0, 0, 0, 0, 0, 0>
// Release: Outputs <0, 0, 0, 0, 0, 0, 0, 0>

public class C1
{
    public Vector256<float> F5;

    public C1(Vector256<float> f5)
    {
        F5 = f5;
    }
}

public class Runtime_106610
{
    [Fact]
    public static void TestEntryPoint()
    {
        if (Avx512DQ.VL.IsSupported)
        {
            var vr4 = Vector256.Create<float>(0);
            var vr5 = Vector256.CreateScalar(1f);
            var vr6 = Vector256.CreateScalar(-10f);
            var vr7 = Avx.Or(vr5, vr6);
            C1 vr8 = new C1(Avx512DQ.VL.Range(vr4, vr7, 0));
            Assert.Equal(Vector256.CreateScalar<uint>(4292870144), vr8.F5.AsUInt32());
        }
    }
}
