
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_struct_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CommPkgDestroy( HYPRE_CommPkg comm_pkg )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CommPkgDestroy_pre( precision, comm_pkg );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridAssemble( HYPRE_StructGrid grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGridAssemble_pre( precision, grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridCoarsen( HYPRE_StructGrid grid, HYPRE_Int *stride, HYPRE_StructGrid *cgrid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGridCoarsen_pre( precision, grid, stride, cgrid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridCreate( MPI_Comm comm, HYPRE_Int ndim, HYPRE_StructGrid *grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGridCreate_pre( precision, comm, ndim, grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridDestroy( HYPRE_StructGrid grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGridDestroy_pre( precision, grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridPrintVTK( const char *filename, HYPRE_StructGrid grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGridPrintVTK_pre( precision, filename, grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridProjectBox( HYPRE_StructGrid grid, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *origin, HYPRE_Int *stride )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGridProjectBox_pre( precision, grid, ilower, iupper, origin, stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridSetExtents( HYPRE_StructGrid grid, HYPRE_Int *ilower, HYPRE_Int *iupper )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGridSetExtents_pre( precision, grid, ilower, iupper );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridSetNumGhost( HYPRE_StructGrid grid, HYPRE_Int *num_ghost )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGridSetNumGhost_pre( precision, grid, num_ghost );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridSetPeriodic( HYPRE_StructGrid grid, HYPRE_Int *periodic )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructGridSetPeriodic_pre( precision, grid, periodic );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAddToBoxValues( HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixAddToBoxValues_pre( precision, matrix, ilower, iupper, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAddToBoxValues2( HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixAddToBoxValues2_pre( precision, matrix, ilower, iupper, nentries, entries, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAddToConstantValues( HYPRE_StructMatrix matrix, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixAddToConstantValues_pre( precision, matrix, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAddToValues( HYPRE_StructMatrix matrix, HYPRE_Int *index, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixAddToValues_pre( precision, matrix, index, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAssemble( HYPRE_StructMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixAssemble_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixClearBoundary( HYPRE_StructMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixClearBoundary_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixCreate( MPI_Comm comm, HYPRE_StructGrid grid, HYPRE_StructStencil stencil, HYPRE_StructMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixCreate_pre( precision, comm, grid, stencil, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixDestroy( HYPRE_StructMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixDestroy_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixGetBoxValues( HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixGetBoxValues_pre( precision, matrix, ilower, iupper, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixGetBoxValues2( HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixGetBoxValues2_pre( precision, matrix, ilower, iupper, nentries, entries, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixGetGrid( HYPRE_StructMatrix matrix, HYPRE_StructGrid *grid )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixGetGrid_pre( precision, matrix, grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixGetValues( HYPRE_StructMatrix matrix, HYPRE_Int *index, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixGetValues_pre( precision, matrix, index, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixInitialize( HYPRE_StructMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixInitialize_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixMatmat( HYPRE_StructMatrix A, HYPRE_Int Atranspose, HYPRE_StructMatrix B, HYPRE_Int Btranspose, HYPRE_StructMatrix *C )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixMatmat_pre( precision, A, Atranspose, B, Btranspose, C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixMatvec( hypre_long_double alpha, HYPRE_StructMatrix A, HYPRE_StructVector x, hypre_long_double beta, HYPRE_StructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixMatvec_pre( precision, alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixMatvecT( hypre_long_double alpha, HYPRE_StructMatrix A, HYPRE_StructVector x, hypre_long_double beta, HYPRE_StructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixMatvecT_pre( precision, alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixPrint( const char *filename, HYPRE_StructMatrix matrix, HYPRE_Int all )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixPrint_pre( precision, filename, matrix, all );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixRead( MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost, HYPRE_StructMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixRead_pre( precision, comm, filename, num_ghost, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetBoxValues( HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetBoxValues_pre( precision, matrix, ilower, iupper, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetBoxValues2( HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetBoxValues2_pre( precision, matrix, ilower, iupper, nentries, entries, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetConstantEntries( HYPRE_StructMatrix matrix, HYPRE_Int nentries, HYPRE_Int *entries )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetConstantEntries_pre( precision, matrix, nentries, entries );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetConstantValues( HYPRE_StructMatrix matrix, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetConstantValues_pre( precision, matrix, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetDomainStride( HYPRE_StructMatrix matrix, HYPRE_Int *domain_stride )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetDomainStride_pre( precision, matrix, domain_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetNumGhost( HYPRE_StructMatrix matrix, HYPRE_Int *num_ghost )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetNumGhost_pre( precision, matrix, num_ghost );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetRangeStride( HYPRE_StructMatrix matrix, HYPRE_Int *range_stride )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetRangeStride_pre( precision, matrix, range_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetSymmetric( HYPRE_StructMatrix matrix, HYPRE_Int symmetric )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetSymmetric_pre( precision, matrix, symmetric );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetTranspose( HYPRE_StructMatrix matrix, HYPRE_Int transpose )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetTranspose_pre( precision, matrix, transpose );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetValues( HYPRE_StructMatrix matrix, HYPRE_Int *index, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructMatrixSetValues_pre( precision, matrix, index, nentries, entries, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructStencilCreate( HYPRE_Int ndim, HYPRE_Int size, HYPRE_StructStencil *stencil )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructStencilCreate_pre( precision, ndim, size, stencil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructStencilDestroy( HYPRE_StructStencil stencil )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructStencilDestroy_pre( precision, stencil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructStencilSetElement( HYPRE_StructStencil stencil, HYPRE_Int entry, HYPRE_Int *offset )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructStencilSetElement_pre( precision, stencil, entry, offset );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructStencilSetEntry( HYPRE_StructStencil stencil, HYPRE_Int entry, HYPRE_Int *offset )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructStencilSetEntry_pre( precision, stencil, entry, offset );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAddToBoxValues( HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorAddToBoxValues_pre( precision, vector, ilower, iupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAddToBoxValues2( HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorAddToBoxValues2_pre( precision, vector, ilower, iupper, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAddToValues( HYPRE_StructVector vector, HYPRE_Int *index, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorAddToValues_pre( precision, vector, index, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAssemble( HYPRE_StructVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorAssemble_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAxpy( hypre_long_double alpha, HYPRE_StructVector x, hypre_long_double beta, HYPRE_StructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorAxpy_pre( precision, alpha, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorClone( HYPRE_StructVector x, HYPRE_StructVector *y_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorClone_pre( precision, x, y_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorCopy( HYPRE_StructVector x, HYPRE_StructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorCopy_pre( precision, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorCreate( MPI_Comm comm, HYPRE_StructGrid grid, HYPRE_StructVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorCreate_pre( precision, comm, grid, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorDestroy( HYPRE_StructVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorDestroy_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorGetBoxValues( HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorGetBoxValues_pre( precision, vector, ilower, iupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorGetBoxValues2( HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorGetBoxValues2_pre( precision, vector, ilower, iupper, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorGetMigrateCommPkg( HYPRE_StructVector from_vector, HYPRE_StructVector to_vector, HYPRE_CommPkg *comm_pkg )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorGetMigrateCommPkg_pre( precision, from_vector, to_vector, comm_pkg );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorGetValues( HYPRE_StructVector vector, HYPRE_Int *index, void *value )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorGetValues_pre( precision, vector, index, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorInitialize( HYPRE_StructVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorInitialize_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorInnerProd( HYPRE_StructVector x, HYPRE_StructVector y, void *result )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorInnerProd_pre( precision, x, y, result );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorMigrate( HYPRE_CommPkg comm_pkg, HYPRE_StructVector from_vector, HYPRE_StructVector to_vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorMigrate_pre( precision, comm_pkg, from_vector, to_vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorPrint( const char *filename, HYPRE_StructVector vector, HYPRE_Int all )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorPrint_pre( precision, filename, vector, all );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorRead( MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost, HYPRE_StructVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorRead_pre( precision, comm, filename, num_ghost, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorScale( hypre_long_double alpha, HYPRE_StructVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorScale_pre( precision, alpha, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorScaleValues( HYPRE_StructVector vector, hypre_long_double factor )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorScaleValues_pre( precision, vector, factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetBoxValues( HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorSetBoxValues_pre( precision, vector, ilower, iupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetBoxValues2( HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorSetBoxValues2_pre( precision, vector, ilower, iupper, vilower, viupper, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetConstantValues( HYPRE_StructVector vector, hypre_long_double value )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorSetConstantValues_pre( precision, vector, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetNumGhost( HYPRE_StructVector vector, HYPRE_Int *num_ghost )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorSetNumGhost_pre( precision, vector, num_ghost );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetRandomValues( HYPRE_StructVector vector, HYPRE_Int seed )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorSetRandomValues_pre( precision, vector, seed );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetStride( HYPRE_StructVector vector, HYPRE_Int *stride )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorSetStride_pre( precision, vector, stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetValues( HYPRE_StructVector vector, HYPRE_Int *index, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_StructVectorSetValues_pre( precision, vector, index, values );
}



#endif

