//
// ccsd_sub_r12_left.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//

// This is a code generated by SMITH

#include <algorithm>
#include <chemistry/qc/ccr12/ccsd_sub_r12_left.h>
#include <chemistry/qc/ccr12/tensor.h>
using namespace sc;
  
  
CCSD_SUB_R12_LEFT::CCSD_SUB_R12_LEFT(CCR12_Info* info):z(info){};
CCSD_SUB_R12_LEFT::~CCSD_SUB_R12_LEFT(){};
  
  
  
void CCSD_SUB_R12_LEFT::compute_amp(Ref<Tensor>& out){ //k_i0_offset,z->f1(),z->fr2(),z->in.at(0),z->lambda1(),z->lambda2(),z->t1(),z->t2(),z->v2()=>z->vr2()
  
in.resize(8);
  
smith_0_1(out); //z->vr2()=>out
in.at(1)=new Tensor("ccsd_sub_r12_left_1_0",z->mem());
offset_smith_0_2();
smith_0_2_0(); //z->vr2()=>in.at(1)
in.at(2)=new Tensor("ccsd_sub_r12_left_2_0",z->mem());
offset_smith_1_2();
smith_1_2_0(); //z->f1()=>in.at(2)
smith_2_5(); //z->t1(),z->v2()=>in.at(2)
smith_1_2(); //z->fr2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_2(out); //z->lambda1(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsd_sub_r12_left_1_3",z->mem());
offset_smith_0_3();
smith_1_3(); //z->lambda1(),z->fr2()=>in.at(1)
smith_0_3(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsd_sub_r12_left_1_1",z->mem());
offset_smith_0_6();
in.at(2)=new Tensor("ccsd_sub_r12_left_2_6",z->mem());
offset_smith_1_6();
smith_2_6(); //z->lambda1(),z->fr2()=>in.at(2)
smith_1_6(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsd_sub_r12_left_2_21",z->mem());
offset_smith_1_21();
smith_2_21(); //z->t2(),z->lambda2()=>in.at(2)
smith_1_21(); //z->fr2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_6(out); //z->v2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsd_sub_r12_left_1_2",z->mem());
offset_smith_0_7();
smith_1_7(); //z->t1(),z->lambda1()=>in.at(1)
smith_1_23(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_7(out); //z->vr2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsd_sub_r12_left_1_3",z->mem());
offset_smith_0_8();
smith_0_8_0(); //z->vr2()=>in.at(1)
in.at(2)=new Tensor("ccsd_sub_r12_left_2_0",z->mem());
offset_smith_1_8();
smith_1_8_0(); //z->f1()=>in.at(2)
smith_2_12(); //z->t1(),z->v2()=>in.at(2)
smith_2_19(); //z->t2(),z->v2()=>in.at(2)
smith_1_8(); //z->fr2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsd_sub_r12_left_2_1",z->mem());
offset_smith_1_9();
in.at(3)=new Tensor("ccsd_sub_r12_left_3_0",z->mem());
offset_smith_2_9();
smith_2_9_0(); //z->f1()=>in.at(3)
smith_3_16(); //z->t1(),z->v2()=>in.at(3)
smith_2_9(); //z->fr2(),in.at(3)=>in.at(2)
delete in.at(3);
smith_1_9(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_8(out); //z->lambda2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsd_sub_r12_left_1_4",z->mem());
offset_smith_0_10();
in.at(2)=new Tensor("ccsd_sub_r12_left_2_0",z->mem());
offset_smith_1_10();
smith_1_10_0(); //z->v2()=>in.at(2)
smith_2_14(); //z->t1(),z->v2()=>in.at(2)
smith_1_10(); //z->lambda2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsd_sub_r12_left_2_13",z->mem());
offset_smith_1_13();
smith_2_13(); //z->t1(),z->lambda2()=>in.at(2)
smith_1_13(); //z->v2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsd_sub_r12_left_2_1",z->mem());
offset_smith_1_17();
in.at(3)=new Tensor("ccsd_sub_r12_left_3_17",z->mem());
offset_smith_2_17();
smith_3_17(); //z->t1(),z->lambda2()=>in.at(3)
smith_2_17(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_20(); //z->t2(),z->lambda2()=>in.at(2)
smith_1_17(); //z->v2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_10(out); //z->fr2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsd_sub_r12_left_1_15",z->mem());
offset_smith_0_15();
smith_1_15(); //z->t1(),z->lambda2()=>in.at(1)
smith_0_15(out); //z->vr2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsd_sub_r12_left_1_5",z->mem());
offset_smith_0_18();
in.at(2)=new Tensor("ccsd_sub_r12_left_2_18",z->mem());
offset_smith_1_18();
smith_2_18(); //z->t1(),z->lambda2()=>in.at(2)
smith_1_18(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_22(); //z->t2(),z->lambda2()=>in.at(1)
smith_0_18(out); //z->vr2(),in.at(1)=>out
delete in.at(1);
  
}
  
void CCSD_SUB_R12_LEFT::smith_0_1(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_e()) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        long h3b_0,h4b_0,h1b_0,h2b_0; 
        z->restricted_4(h3b,h4b,h1b,h2b,h3b_0,h4b_0,h1b_0,h2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->vr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h3b),z->get_range(h4b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_10(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^(z->irrep_y()^z->irrep_v()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
          if (z->get_spin(p5b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_e()) { 
            long p5b_0,q6b_0,h1b_0,h2b_0; 
            z->restricted_4(p5b,q6b,h1b,h2b,p5b_0,q6b_0,h1b_0,h2b_0); 
            long h3b_1,h4b_1,p5b_1,q6b_1; 
            z->restricted_4(h3b,h4b,p5b,q6b,h3b_1,h4b_1,p5b_1,q6b_1); 
            long dim_common=z->get_range(p5b)*z->get_range(q6b); 
            long dima0_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->fr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(q6b_0+(z->nab())*(p5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(q6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(q6b_1-z->noab()-z->nvab()+z->ncab()*(p5b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p5b),z->get_range(q6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),1,0,3,2,+1.0); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_0_10(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p5b)+z->get_spin(q6b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p5b)^z->get_sym(q6b))))==(z->irrep_y()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p5b)+z->get_spin(q6b)!=8L) { 
       in[1]->input_offset(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p5b)*z->get_range(q6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_15(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(h5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
           if ((z->get_sym(h5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_e()) { 
            long h5b_0,p6b_0,h1b_0,h2b_0; 
            z->restricted_4(h5b,p6b,h1b,h2b,h5b_0,p6b_0,h1b_0,h2b_0); 
            long h3b_1,h4b_1,h5b_1,p6b_1; 
            z->restricted_4(h3b,h4b,h5b,p6b,h3b_1,h4b_1,h5b_1,p6b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->vr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0+(z->nab())*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(p6b_1-z->noab()+z->nvab()*(h5b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(p6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),1,0,3,2,+1.0); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_0_15(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(p6b)!=8L) { 
       in[1]->input_offset(p6b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_18(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^(z->irrep_t()^(z->irrep_t()^z->irrep_y())))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long h6b=h5b;h6b<z->noab();++h6b) { 
          if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
           if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_e()) { 
            long h5b_0,h6b_0,h1b_0,h2b_0; 
            z->restricted_4(h5b,h6b,h1b,h2b,h5b_0,h6b_0,h1b_0,h2b_0); 
            long h3b_1,h4b_1,h5b_1,h6b_1; 
            z->restricted_4(h3b,h4b,h5b,h6b,h3b_1,h4b_1,h5b_1,h6b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(h6b); 
            long dima0_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->vr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h6b_0+(z->nab())*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(h6b_1+z->noab()*(h5b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(h6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h5b==h6b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),1,0,3,2,+0.5/0.5); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_0_18(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=h5b;h6b<z->noab();++h6b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
       in[1]->input_offset(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_2(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_y()^(z->irrep_e()^z->irrep_f()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(h3b)==z->get_spin(p5b)) { 
          if ((z->get_sym(h3b)^z->get_sym(p5b))==z->irrep_y()) { 
           long h3b_0,p5b_0; 
           z->restricted_2(h3b,p5b,h3b_0,p5b_0); 
           long h4b_1,p5b_1,h1b_1,h2b_1; 
           z->restricted_4(h4b,p5b,h1b,h2b,h4b_1,p5b_1,h1b_1,h2b_1); 
           long dim_common=z->get_range(p5b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->lambda1()->get_block(p5b_0-z->noab()+z->nvab()*(h3b_0),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(p5b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(p5b_1-z->noab()+z->nvab()*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(h4b),z->get_range(h3b),2,3,1,0,-1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_2_0(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p5b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p5b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^z->irrep_f())) { 
        long dimc=z->get_range(h4b)*z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
        long h4b_0,p5b_0,h1b_0,h2b_0; 
        z->restricted_4(h4b,p5b,h1b,h2b,h4b_0,p5b_0,h1b_0,h2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h4b)*z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->vr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0+(z->nab())*(h4b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,-1.0); 
         in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(h4b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_0_2(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    if (z->get_spin(h4b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(p5b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^z->irrep_f())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p5b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
       in[1]->input_offset(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_3(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_v()^(z->irrep_y()^z->irrep_e()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
          if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(q6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(q6b))))==z->irrep_v()) { 
            long h3b_0,h4b_0,h5b_0,q6b_0; 
            z->restricted_4(h3b,h4b,h5b,q6b,h3b_0,h4b_0,h5b_0,q6b_0); 
            long h5b_1,q6b_1,h1b_1,h2b_1; 
            z->restricted_4(h5b,q6b,h1b,h2b,h5b_1,q6b_1,h1b_1,h2b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(q6b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->v2()->get_block(q6b_0+(z->nab())*(h5b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(q6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(q6b_1-z->noab()-z->nvab()+z->ncab()*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(q6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+1.0); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_0_3(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    if (z->get_spin(h5b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_y()^z->irrep_e())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(q6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
       in[1]->input_offset(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_6(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_v()^(z->irrep_t()^(z->irrep_y()^z->irrep_e())))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
          if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p5b)+z->get_spin(q6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p5b)^z->get_sym(q6b))))==z->irrep_v()) { 
            long h3b_0,h4b_0,p5b_0,q6b_0; 
            z->restricted_4(h3b,h4b,p5b,q6b,h3b_0,h4b_0,p5b_0,q6b_0); 
            long p5b_1,q6b_1,h1b_1,h2b_1; 
            z->restricted_4(p5b,q6b,h1b,h2b,p5b_1,q6b_1,h1b_1,h2b_1); 
            long dim_common=z->get_range(p5b)*z->get_range(q6b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->v2()->get_block(q6b_0+(z->nab())*(p5b_0+(z->nab())*(h4b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p5b),z->get_range(q6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(q6b_1-z->noab()-z->nvab()+z->ncab()*(p5b_1-z->noab()))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(q6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+1.0); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_0_6(){ 
 
long size=0L; 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    if (z->get_spin(p5b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
     if ((z->get_sym(p5b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^(z->irrep_y()^z->irrep_e()))) { 
      if (!z->restricted() || z->get_spin(p5b)+z->get_spin(q6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
       in[1]->input_offset(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()))),size); 
       size+=z->get_range(p5b)*z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_7(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         if (z->get_spin(h3b)+z->get_spin(h5b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h5b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_e()) { 
           long h3b_0,h5b_0,h1b_0,h2b_0; 
           z->restricted_4(h3b,h5b,h1b,h2b,h3b_0,h5b_0,h1b_0,h2b_0); 
           long h4b_1,h5b_1; 
           z->restricted_2(h4b,h5b,h4b_1,h5b_1); 
           long dim_common=z->get_range(h5b); 
           long dima0_sort=z->get_range(h3b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h3b<h5b) { 
             z->vr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h5b_0+(z->nab())*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
            } 
            else if (h5b<=h3b) { 
             z->vr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h3b_0+(z->nab())*(h5b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[1]->get_block(h5b_1+z->noab()*(h4b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h1b),z->get_range(h3b),3,0,2,1,+1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h1b),z->get_range(h3b),0,3,2,1,-1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_0_7(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  if (z->get_spin(h4b)==z->get_spin(h5b)) { 
   if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_y())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
     in[1]->input_offset(h5b+z->noab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(h5b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_8(Ref<Tensor>& out){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_y()^(z->irrep_e()^z->irrep_f()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p5b)+z->get_spin(p6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p5b)^z->get_sym(p6b))))==z->irrep_y()) { 
            long h3b_0,h4b_0,p5b_0,p6b_0; 
            z->restricted_4(h3b,h4b,p5b,p6b,h3b_0,h4b_0,p5b_0,p6b_0); 
            long p5b_1,p6b_1,h1b_1,h2b_1; 
            z->restricted_4(p5b,p6b,h1b,h2b,p5b_1,p6b_1,h1b_1,h2b_1); 
            long dim_common=z->get_range(p5b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->lambda2()->get_block(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p5b),z->get_range(p6b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[1]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(p5b_1-z->noab()))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p5b==p6b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(h4b),z->get_range(h3b),3,2,1,0,+0.5/0.5); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_0_8_0(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^z->irrep_f())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
        long p5b_0,p6b_0,h1b_0,h2b_0; 
        z->restricted_4(p5b,p6b,h1b,h2b,p5b_0,p6b_0,h1b_0,h2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->vr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0+(z->nab())*(p5b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
         in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_0_8(){ 
 
long size=0L; 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
     if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^z->irrep_f())) { 
      if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
       in[1]->input_offset(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),size); 
       size+=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_10(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p5b)+z->get_spin(q6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p5b)+z->get_spin(q6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p5b)^z->get_sym(q6b))))==(z->irrep_y()^z->irrep_v())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p5b)*z->get_range(q6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(h3b)+z->get_spin(h7b)==z->get_spin(p5b)+z->get_spin(p8b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h7b)^(z->get_sym(p5b)^z->get_sym(p8b))))==z->irrep_y()) { 
            long h3b_0,h7b_0,p5b_0,p8b_0; 
            z->restricted_4(h3b,h7b,p5b,p8b,h3b_0,h7b_0,p5b_0,p8b_0); 
            long h4b_1,p8b_1,h7b_1,q6b_1; 
            z->restricted_4(h4b,p8b,h7b,q6b,h4b_1,p8b_1,h7b_1,q6b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(p5b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(q6b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h3b<h7b && p5b<p8b) { 
              z->lambda2()->get_block(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(h7b_0+z->noab()*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h7b),z->get_range(p5b),z->get_range(p8b),2,0,3,1,+1.0); 
             } 
             else if (h3b<h7b && p8b<=p5b) { 
              z->lambda2()->get_block(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(h7b_0+z->noab()*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h7b),z->get_range(p8b),z->get_range(p5b),3,0,2,1,-1.0); 
             } 
             else if (h7b<=h3b && p5b<p8b) { 
              z->lambda2()->get_block(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(h3b_0+z->noab()*(h7b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h3b),z->get_range(p5b),z->get_range(p8b),2,1,3,0,-1.0); 
             } 
             else if (h7b<=h3b && p8b<=p5b) { 
              z->lambda2()->get_block(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(h3b_0+z->noab()*(h7b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h3b),z->get_range(p8b),z->get_range(p5b),3,1,2,0,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[2]->get_block(q6b_1-z->noab()-z->nvab()+z->ncab()*(h7b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p8b),z->get_range(h7b),z->get_range(q6b),3,0,1,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(q6b),z->get_range(h4b),z->get_range(p5b),z->get_range(h3b),3,1,2,0,+1.0); 
         in[1]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(q6b),z->get_range(h4b),z->get_range(p5b),z->get_range(h3b),1,3,2,0,-1.0); 
         in[1]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_10_0(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    long tileoffset; 
    tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p8b)+z->get_spin(h7b)+z->get_spin(q6b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p8b)==z->get_spin(h7b)+z->get_spin(q6b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p8b)^(z->get_sym(h7b)^z->get_sym(q6b))))==z->irrep_v()) { 
        long dimc=z->get_range(h4b)*z->get_range(p8b)*z->get_range(h7b)*z->get_range(q6b); 
        long h4b_0,p8b_0,h7b_0,q6b_0; 
        z->restricted_4(h4b,p8b,h7b,q6b,h4b_0,p8b_0,h7b_0,q6b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h4b)*z->get_range(p8b)*z->get_range(h7b)*z->get_range(q6b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(q6b_0+(z->nab())*(h7b_0+(z->nab())*(p8b_0+(z->nab())*(h4b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(p8b),z->get_range(h7b),z->get_range(q6b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h7b),z->get_range(q6b),0,1,2,3,-1.0); 
         in[2]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_1_10(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    if (z->get_spin(h4b)+z->get_spin(p8b)==z->get_spin(h7b)+z->get_spin(q6b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(p8b)^(z->get_sym(h7b)^z->get_sym(q6b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p8b)+z->get_spin(h7b)+z->get_spin(q6b)!=8L) { 
       in[2]->input_offset(q6b-z->noab()-z->nvab()+z->ncab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(p8b)*z->get_range(h7b)*z->get_range(q6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_13(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p5b)+z->get_spin(q6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p5b)+z->get_spin(q6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p5b)^z->get_sym(q6b))))==(z->irrep_v()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p5b)*z->get_range(q6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long h8b=0L;h8b<z->noab();++h8b) { 
          if (z->get_spin(h3b)+z->get_spin(h7b)==z->get_spin(h8b)+z->get_spin(q6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h7b)^(z->get_sym(h8b)^z->get_sym(q6b))))==z->irrep_v()) { 
            long h3b_0,h7b_0,h8b_0,q6b_0; 
            z->restricted_4(h3b,h7b,h8b,q6b,h3b_0,h7b_0,h8b_0,q6b_0); 
            long h4b_1,h8b_1,h7b_1,p5b_1; 
            z->restricted_4(h4b,h8b,h7b,p5b,h4b_1,h8b_1,h7b_1,p5b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(h8b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(q6b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p5b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h3b<h7b) { 
              z->v2()->get_block(q6b_0+(z->nab())*(h8b_0+(z->nab())*(h7b_0+(z->nab())*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h7b),z->get_range(h8b),z->get_range(q6b),3,0,2,1,+1.0); 
             } 
             else if (h7b<=h3b) { 
              z->v2()->get_block(q6b_0+(z->nab())*(h8b_0+(z->nab())*(h3b_0+(z->nab())*(h7b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h3b),z->get_range(h8b),z->get_range(q6b),3,1,2,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h4b<h8b) { 
              in[2]->get_block(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h8b_1+z->noab()*(h4b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(h7b),z->get_range(p5b),3,0,1,2,+1.0); 
             } 
             else if (h8b<=h4b) { 
              in[2]->get_block(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h4b_1+z->noab()*(h8b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(h7b),z->get_range(p5b),3,1,0,2,-1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h4b),z->get_range(q6b),z->get_range(h3b),3,1,0,2,+1.0); 
         in[1]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h4b),z->get_range(q6b),z->get_range(h3b),1,3,0,2,-1.0); 
         in[1]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_1_13(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h8b=h4b;h8b<z->noab();++h8b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    if (z->get_spin(h4b)+z->get_spin(h8b)==z->get_spin(h7b)+z->get_spin(p5b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(h8b)^(z->get_sym(h7b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h8b)+z->get_spin(h7b)+z->get_spin(p5b)!=8L) { 
       in[2]->input_offset(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(h8b+z->noab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(h8b)*z->get_range(h7b)*z->get_range(p5b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_15(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(p6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p7b_0,h5b_0; 
           z->restricted_2(p7b,h5b,p7b_0,h5b_0); 
           long h3b_1,h4b_1,p6b_1,p7b_1; 
           z->restricted_4(h3b,h4b,p6b,p7b,h3b_1,h4b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p6b<p7b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p6b),z->get_range(p7b),2,1,0,3,+1.0); 
            } 
            else if (p7b<=p6b) { 
             z->lambda2()->get_block(p6b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p7b),z->get_range(p6b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,3,0,+1.0); 
        in[1]->add_block(p6b-z->noab()+z->nvab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_17(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p5b)+z->get_spin(q6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(p5b)+z->get_spin(q6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(p5b)^z->get_sym(q6b))))==(z->irrep_v()^(z->irrep_t()^(z->irrep_t()^z->irrep_y())))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p5b)*z->get_range(q6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(h3b)+z->get_spin(h7b)==z->get_spin(p8b)+z->get_spin(q6b)) { 
           if ((z->get_sym(h3b)^(z->get_sym(h7b)^(z->get_sym(p8b)^z->get_sym(q6b))))==z->irrep_v()) { 
            long h3b_0,h7b_0,p8b_0,q6b_0; 
            z->restricted_4(h3b,h7b,p8b,q6b,h3b_0,h7b_0,p8b_0,q6b_0); 
            long h4b_1,p8b_1,h7b_1,p5b_1; 
            z->restricted_4(h4b,p8b,h7b,p5b,h4b_1,p8b_1,h7b_1,p5b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(q6b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p5b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (h3b<h7b) { 
              z->v2()->get_block(q6b_0+(z->nab())*(p8b_0+(z->nab())*(h7b_0+(z->nab())*(h3b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h7b),z->get_range(p8b),z->get_range(q6b),3,0,2,1,+1.0); 
             } 
             else if (h7b<=h3b) { 
              z->v2()->get_block(q6b_0+(z->nab())*(p8b_0+(z->nab())*(h3b_0+(z->nab())*(h7b_0))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h3b),z->get_range(p8b),z->get_range(q6b),3,1,2,0,-1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[2]->get_block(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p8b),z->get_range(h7b),z->get_range(p5b),3,0,1,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h4b),z->get_range(q6b),z->get_range(h3b),3,1,0,2,+1.0); 
         in[1]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h4b),z->get_range(q6b),z->get_range(h3b),1,3,0,2,-1.0); 
         in[1]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_1_17(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    if (z->get_spin(h4b)+z->get_spin(p8b)==z->get_spin(h7b)+z->get_spin(p5b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(p8b)^(z->get_sym(h7b)^z->get_sym(p5b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p8b)+z->get_spin(h7b)+z->get_spin(p5b)!=8L) { 
       in[2]->input_offset(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(p8b)*z->get_range(h7b)*z->get_range(p5b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_18(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=0L;h6b<z->noab();++h6b) { 
    long tileoffset; 
    if (h5b<h6b) { 
     tileoffset=(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    } 
    else if (h6b<=h5b) { 
     tileoffset=(h5b+z->noab()*(h6b+z->noab()*(h4b+z->noab()*(h3b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p7b_0,h5b_0; 
           z->restricted_2(p7b,h5b,p7b_0,h5b_0); 
           long h3b_1,h4b_1,h6b_1,p7b_1; 
           z->restricted_4(h3b,h4b,h6b,p7b,h3b_1,h4b_1,h6b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h5b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h5b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p7b_1-z->noab()+z->nvab()*(h6b_1+z->noab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h6b),z->get_range(p7b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h6b>=h5b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,3,0,+1.0); 
         in[1]->add_block(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        if (h5b>=h6b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h4b),z->get_range(h3b),z->get_range(h5b),2,1,0,3,-1.0); 
         in[1]->add_block(h5b+z->noab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_1_18(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h6b=0L;h6b<z->noab();++h6b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h6b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h6b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h6b)+z->get_spin(p7b)!=8L) { 
       in[2]->input_offset(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),size); 
       size+=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_2(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p5b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p5b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^z->irrep_f())) { 
        long dimc=z->get_range(h4b)*z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
         if (z->get_spin(p5b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_e()) { 
           long p5b_0,q6b_0,h1b_0,h2b_0; 
           z->restricted_4(p5b,q6b,h1b,h2b,p5b_0,q6b_0,h1b_0,h2b_0); 
           long h4b_1,q6b_1; 
           z->restricted_2(h4b,q6b,h4b_1,q6b_1); 
           long dim_common=z->get_range(q6b); 
           long dima0_sort=z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->fr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(q6b_0+(z->nab())*(p5b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(q6b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(q6b_1-z->noab()-z->nvab()+z->ncab()*(h4b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(q6b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),0,3,2,1,+1.0); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_21(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(q6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(p5b)*z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
          if ((z->get_sym(p7b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_e()) { 
           long p7b_0,q6b_0,h1b_0,h2b_0; 
           z->restricted_4(p7b,q6b,h1b,h2b,p7b_0,q6b_0,h1b_0,h2b_0); 
           long p5b_1,p7b_1; 
           z->restricted_2(p5b,p7b,p5b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->fr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(q6b_0+(z->nab())*(p7b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(q6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(p7b_1-z->noab()+z->nvab()*(p5b_1-z->noab()),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p7b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(q6b),0,3,2,1,+1.0); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_1_21(){ 
 
long size=0L; 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  if (z->get_spin(p5b)==z->get_spin(p7b)) { 
   if ((z->get_sym(p5b)^z->get_sym(p7b))==(z->irrep_t()^z->irrep_y())) { 
    if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p7b)!=4L) { 
     in[2]->input_offset(p7b-z->noab()+z->nvab()*(p5b-z->noab()),size); 
     size+=z->get_range(p5b)*z->get_range(p7b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_22(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h5b=0L;h5b<z->noab();++h5b) { 
   for (long h6b=h5b;h6b<z->noab();++h6b) { 
    long tileoffset; 
    tileoffset=(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h6b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h5b)^z->get_sym(h6b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h5b_0,h6b_0; 
            z->restricted_4(p7b,p8b,h5b,h6b,p7b_0,p8b_0,h5b_0,h6b_0); 
            long h3b_1,h4b_1,p7b_1,p8b_1; 
            z->restricted_4(h3b,h4b,p7b,p8b,h3b_1,h4b_1,p7b_1,p8b_1); 
            long dim_common=z->get_range(p7b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(h5b)*z->get_range(h6b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h6b_0+z->noab()*(h5b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h5b),z->get_range(h6b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p7b),z->get_range(p8b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p7b==p8b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h6b),z->get_range(h5b),1,0,3,2,+0.5/0.5); 
        in[1]->add_block(h6b+z->noab()*(h5b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_23(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  long tileoffset; 
  tileoffset=(h5b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h5b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(h4b)*z->get_range(h5b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h5b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h5b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long p6b_0,p7b_0,h5b_0,h8b_0; 
           z->restricted_4(p6b,p7b,h5b,h8b,p6b_0,p7b_0,h5b_0,h8b_0); 
           long h4b_1,h8b_1,p6b_1,p7b_1; 
           z->restricted_4(h4b,h8b,p6b,p7b,h4b_1,h8b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(h8b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (h5b<h8b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h5b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h5b),z->get_range(h8b),2,1,0,3,+1.0); 
            } 
            else if (h8b<=h5b) { 
             z->t2()->get_block(h5b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h5b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h4b<h8b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),0,3,2,1,+1.0); 
            } 
            else if (h8b<=h4b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(p6b),z->get_range(p7b),1,3,2,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (p6b==p7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h5b),0,1,-0.5/0.5); 
      in[1]->add_block(h5b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_2_0(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  long tileoffset; 
  tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(h4b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(q6b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(q6b)) { 
     if ((z->get_sym(h4b)^z->get_sym(q6b))==z->irrep_f()) { 
      long dimc=z->get_range(h4b)*z->get_range(q6b); 
      long h4b_0,q6b_0; 
      z->restricted_2(h4b,q6b,h4b_0,q6b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h4b)*z->get_range(q6b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(q6b_0+(z->nab())*(h4b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(q6b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(h4b),z->get_range(q6b),0,1,+1.0); 
       in[2]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(h4b),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_1_2(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  if (z->get_spin(h4b)==z->get_spin(q6b)) { 
   if ((z->get_sym(h4b)^z->get_sym(q6b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(q6b)!=4L) { 
     in[2]->input_offset(q6b-z->noab()-z->nvab()+z->ncab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(q6b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_3(){ 
      
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h5b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(q6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_y()^z->irrep_e())) { 
        long dimc=z->get_range(h5b)*z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(h5b)==z->get_spin(p7b)) { 
          if ((z->get_sym(h5b)^z->get_sym(p7b))==z->irrep_y()) { 
           long h5b_0,p7b_0; 
           z->restricted_2(h5b,p7b,h5b_0,p7b_0); 
           long p7b_1,q6b_1,h1b_1,h2b_1; 
           z->restricted_4(p7b,q6b,h1b,h2b,p7b_1,q6b_1,h1b_1,h2b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->lambda1()->get_block(p7b_0-z->noab()+z->nvab()*(h5b_0),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(p7b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->fr2()->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(q6b_1+(z->nab())*(p7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(q6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(q6b),z->get_range(h5b),3,2,1,0,-1.0); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h5b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_6(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(q6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^(z->irrep_y()^z->irrep_e()))) { 
        long dimc=z->get_range(p5b)*z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         if (z->get_spin(p5b)==z->get_spin(h7b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h7b))==z->irrep_t()) { 
           long p5b_0,h7b_0; 
           z->restricted_2(p5b,h7b,p5b_0,h7b_0); 
           long h7b_1,q6b_1,h1b_1,h2b_1; 
           z->restricted_4(h7b,q6b,h1b,h2b,h7b_1,q6b_1,h1b_1,h2b_1); 
           long dim_common=z->get_range(h7b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h7b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h7b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(q6b_1-z->noab()-z->nvab()+z->ncab()*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(q6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(q6b),z->get_range(p5b),3,2,1,0,+1.0); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(p5b-z->noab()))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_1_6(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    if (z->get_spin(h7b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_y()^z->irrep_e())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(q6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
       in[2]->input_offset(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_7(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=0L;h5b<z->noab();++h5b) { 
  long tileoffset; 
  tileoffset=(h5b+z->noab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(h5b)) { 
     if ((z->get_sym(h4b)^z->get_sym(h5b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(h4b)*z->get_range(h5b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
       if (z->get_spin(p6b)==z->get_spin(h5b)) { 
        if ((z->get_sym(p6b)^z->get_sym(h5b))==z->irrep_t()) { 
         long p6b_0,h5b_0; 
         z->restricted_2(p6b,h5b,p6b_0,h5b_0); 
         long h4b_1,p6b_1; 
         z->restricted_2(h4b,p6b,h4b_1,p6b_1); 
         long dim_common=z->get_range(p6b); 
         long dima0_sort=z->get_range(h5b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h4b); 
         long dima1=dim_common*dima1_sort; 
         if (dima0>0L && dima1>0L) { 
          double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
          double* k_a0=z->mem()->malloc_local_double(dima0); 
          z->t1()->get_block(h5b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h5b),1,0,+1.0); 
          z->mem()->free_local_double(k_a0); 
          double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
          double* k_a1=z->mem()->malloc_local_double(dima1); 
          z->lambda1()->get_block(p6b_1-z->noab()+z->nvab()*(h4b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p6b),0,1,+1.0); 
          z->mem()->free_local_double(k_a1); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          z->mem()->free_local_double(k_a1_sort); 
          z->mem()->free_local_double(k_a0_sort); 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h5b),0,1,-1.0); 
      in[1]->add_block(h5b+z->noab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_8(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (p5b<p6b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    } 
    else if (p6b<=p5b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^z->irrep_f())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long q7b=z->noab()+z->nvab();q7b<z->nab();++q7b) { 
         if (z->get_spin(p5b)+z->get_spin(q7b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(q7b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_e()) { 
           long p5b_0,q7b_0,h1b_0,h2b_0; 
           z->restricted_4(p5b,q7b,h1b,h2b,p5b_0,q7b_0,h1b_0,h2b_0); 
           long p6b_1,q7b_1; 
           z->restricted_2(p6b,q7b,p6b_1,q7b_1); 
           long dim_common=z->get_range(q7b); 
           long dima0_sort=z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->fr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(q7b_0+(z->nab())*(p5b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(q7b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(q7b_1-z->noab()-z->nvab()+z->ncab()*(p6b_1-z->noab()),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(p6b),z->get_range(q7b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p6b>=p5b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),3,0,2,1,+1.0); 
         in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
        } 
        if (p5b>=p6b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),0,3,2,1,-1.0); 
         in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_8_0(){ 
      
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long q7b=z->noab()+z->nvab();q7b<z->nab();++q7b) { 
  long tileoffset; 
  tileoffset=(q7b-z->noab()-z->nvab()+z->ncab()*(p6b-z->noab())); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p6b)+z->get_spin(q7b)!=4L) { 
    if (z->get_spin(p6b)==z->get_spin(q7b)) { 
     if ((z->get_sym(p6b)^z->get_sym(q7b))==z->irrep_f()) { 
      long dimc=z->get_range(p6b)*z->get_range(q7b); 
      long p6b_0,q7b_0; 
      z->restricted_2(p6b,q7b,p6b_0,q7b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(p6b)*z->get_range(q7b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(q7b_0+(z->nab())*(p6b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(q7b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(p6b),z->get_range(q7b),0,1,+1.0); 
       in[2]->add_block(q7b-z->noab()-z->nvab()+z->ncab()*(p6b-z->noab()),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_1_8(){ 
 
long size=0L; 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long q7b=z->noab()+z->nvab();q7b<z->nab();++q7b) { 
  if (z->get_spin(p6b)==z->get_spin(q7b)) { 
   if ((z->get_sym(p6b)^z->get_sym(q7b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(p6b)+z->get_spin(q7b)!=4L) { 
     in[2]->input_offset(q7b-z->noab()-z->nvab()+z->ncab()*(p6b-z->noab()),size); 
     size+=z->get_range(p6b)*z->get_range(q7b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_1_9(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (p5b<p6b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    } 
    else if (p6b<=p5b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^(z->irrep_e()^z->irrep_f()))) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         if (z->get_spin(p5b)==z->get_spin(h7b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h7b))==z->irrep_t()) { 
           long p5b_0,h7b_0; 
           z->restricted_2(p5b,h7b,p5b_0,h7b_0); 
           long h7b_1,p6b_1,h1b_1,h2b_1; 
           z->restricted_4(h7b,p6b,h1b,h2b,h7b_1,p6b_1,h1b_1,h2b_1); 
           long dim_common=z->get_range(h7b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h7b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h7b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[2]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p6b>=p5b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,2,1,0,+1.0); 
         in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
        } 
        if (p5b>=p6b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,3,1,0,-1.0); 
         in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_1_9(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^z->irrep_f())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
       in[2]->input_offset(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_12(){ 
      
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long q7b=z->noab()+z->nvab();q7b<z->nab();++q7b) { 
  long tileoffset; 
  tileoffset=(q7b-z->noab()-z->nvab()+z->ncab()*(p6b-z->noab())); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p6b)+z->get_spin(q7b)!=4L) { 
    if (z->get_spin(p6b)==z->get_spin(q7b)) { 
     if ((z->get_sym(p6b)^z->get_sym(q7b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p6b)*z->get_range(q7b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h9b=0L;h9b<z->noab();++h9b) { 
       for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
        if (z->get_spin(p8b)==z->get_spin(h9b)) { 
         if ((z->get_sym(p8b)^z->get_sym(h9b))==z->irrep_t()) { 
          long p8b_0,h9b_0; 
          z->restricted_2(p8b,h9b,p8b_0,h9b_0); 
          long h9b_1,p6b_1,p8b_1,q7b_1; 
          z->restricted_4(h9b,p6b,p8b,q7b,h9b_1,p6b_1,p8b_1,q7b_1); 
          long dim_common=z->get_range(h9b)*z->get_range(p8b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(p6b)*z->get_range(q7b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h9b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h9b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           z->v2()->get_block(q7b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p6b),z->get_range(p8b),z->get_range(q7b),3,1,2,0,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(q7b),z->get_range(p6b),1,0,+1.0); 
      in[2]->add_block(q7b-z->noab()-z->nvab()+z->ncab()*(p6b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_13(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h8b=h4b;h8b<z->noab();++h8b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(h8b+z->noab()*(h4b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h8b)+z->get_spin(h7b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(h8b)==z->get_spin(h7b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(h8b)^(z->get_sym(h7b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h4b)*z->get_range(h8b)*z->get_range(h7b)*z->get_range(p5b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h7b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h7b))==z->irrep_t()) { 
           long p9b_0,h7b_0; 
           z->restricted_2(p9b,h7b,p9b_0,h7b_0); 
           long h4b_1,h8b_1,p5b_1,p9b_1; 
           z->restricted_4(h4b,h8b,p5b,p9b,h4b_1,h8b_1,p5b_1,p9b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h7b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h8b)*z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h7b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h7b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p5b<p9b) { 
             z->lambda2()->get_block(p9b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p5b),z->get_range(p9b),2,1,0,3,+1.0); 
            } 
            else if (p9b<=p5b) { 
             z->lambda2()->get_block(p5b_1-z->noab()+z->nvab()*(p9b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p9b),z->get_range(p5b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h8b),z->get_range(h4b),z->get_range(h7b),2,1,3,0,-1.0); 
        in[2]->add_block(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(h8b+z->noab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_14(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
    long tileoffset; 
    tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p8b)+z->get_spin(h7b)+z->get_spin(q6b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p8b)==z->get_spin(h7b)+z->get_spin(q6b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p8b)^(z->get_sym(h7b)^z->get_sym(q6b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h4b)*z->get_range(p8b)*z->get_range(h7b)*z->get_range(q6b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h7b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h7b))==z->irrep_t()) { 
           long p9b_0,h7b_0; 
           z->restricted_2(p9b,h7b,p9b_0,h7b_0); 
           long h4b_1,p8b_1,p9b_1,q6b_1; 
           z->restricted_4(h4b,p8b,p9b,q6b,h4b_1,p8b_1,p9b_1,q6b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h7b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(p8b)*z->get_range(q6b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h7b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h7b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->v2()->get_block(q6b_1+(z->nab())*(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p8b),z->get_range(p9b),z->get_range(q6b),3,1,0,2,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(q6b),z->get_range(p8b),z->get_range(h4b),z->get_range(h7b),2,1,3,0,-1.0); 
        in[2]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_17(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p8b)+z->get_spin(h7b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p8b)==z->get_spin(h7b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p8b)^(z->get_sym(h7b)^z->get_sym(p5b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_y()))) { 
        long dimc=z->get_range(h4b)*z->get_range(p8b)*z->get_range(h7b)*z->get_range(p5b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h9b=0L;h9b<z->noab();++h9b) { 
         if (z->get_spin(p8b)==z->get_spin(h9b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h9b))==z->irrep_t()) { 
           long p8b_0,h9b_0; 
           z->restricted_2(p8b,h9b,p8b_0,h9b_0); 
           long h4b_1,h9b_1,h7b_1,p5b_1; 
           z->restricted_4(h4b,h9b,h7b,p5b,h4b_1,h9b_1,h7b_1,p5b_1); 
           long dim_common=z->get_range(h9b); 
           long dima0_sort=z->get_range(p8b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h7b)*z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h9b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h9b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h4b<h9b) { 
             in[3]->get_block(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h9b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h9b),z->get_range(h7b),z->get_range(p5b),3,2,0,1,+1.0); 
            } 
            else if (h9b<=h4b) { 
             in[3]->get_block(p5b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h4b_1+z->noab()*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h4b),z->get_range(h7b),z->get_range(p5b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h7b),z->get_range(h4b),z->get_range(p8b),2,3,1,0,+1.0); 
        in[2]->add_block(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_2_17(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h9b=h4b;h9b<z->noab();++h9b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    if (z->get_spin(h4b)+z->get_spin(h9b)==z->get_spin(h7b)+z->get_spin(p5b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(h9b)^(z->get_sym(h7b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_y())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h9b)+z->get_spin(h7b)+z->get_spin(p5b)!=8L) { 
       in[3]->input_offset(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(h9b+z->noab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(h9b)*z->get_range(h7b)*z->get_range(p5b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_18(){ 
      
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h4b=h3b;h4b<z->noab();++h4b) { 
  for (long h6b=0L;h6b<z->noab();++h6b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h6b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h6b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h6b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h6b)*z->get_range(p7b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p8b_0,h6b_0; 
           z->restricted_2(p8b,h6b,p8b_0,h6b_0); 
           long h3b_1,h4b_1,p7b_1,p8b_1; 
           z->restricted_4(h3b,h4b,p7b,p8b,h3b_1,h4b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h6b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b)*z->get_range(h4b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h6b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h6b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p8b) { 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p7b),z->get_range(p8b),2,1,0,3,+1.0); 
            } 
            else if (p8b<=p7b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(h6b),2,1,3,0,+0.5); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h6b+z->noab()*(h4b+z->noab()*(h3b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_19(){ 
      
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long q7b=z->noab()+z->nvab();q7b<z->nab();++q7b) { 
  long tileoffset; 
  tileoffset=(q7b-z->noab()-z->nvab()+z->ncab()*(p6b-z->noab())); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p6b)+z->get_spin(q7b)!=4L) { 
    if (z->get_spin(p6b)==z->get_spin(q7b)) { 
     if ((z->get_sym(p6b)^z->get_sym(q7b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p6b)*z->get_range(q7b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h9b=0L;h9b<z->noab();++h9b) { 
       for (long h10b=h9b;h10b<z->noab();++h10b) { 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p6b)+z->get_spin(p8b)==z->get_spin(h9b)+z->get_spin(h10b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(h9b)^z->get_sym(h10b))))==z->irrep_t()) { 
           long p6b_0,p8b_0,h9b_0,h10b_0; 
           z->restricted_4(p6b,p8b,h9b,h10b,p6b_0,p8b_0,h9b_0,h10b_0); 
           long h9b_1,h10b_1,p8b_1,q7b_1; 
           z->restricted_4(h9b,h10b,p8b,q7b,h9b_1,h10b_1,p8b_1,q7b_1); 
           long dim_common=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b); 
           long dima0_sort=z->get_range(p6b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(q7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p6b<p8b) { 
             z->t2()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(h9b),z->get_range(h10b),0,1,3,2,+1.0); 
            } 
            else if (p8b<=p6b) { 
             z->t2()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(h9b),z->get_range(h10b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->v2()->get_block(q7b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p8b),z->get_range(q7b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h9b==h10b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(q7b),z->get_range(p6b),1,0,+0.5/0.5); 
      in[2]->add_block(q7b-z->noab()-z->nvab()+z->ncab()*(p6b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_20(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p8b)+z->get_spin(h7b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(p8b)==z->get_spin(h7b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(p8b)^(z->get_sym(h7b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h4b)*z->get_range(p8b)*z->get_range(h7b)*z->get_range(p5b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h10b=0L;h10b<z->noab();++h10b) { 
         for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
          if (z->get_spin(p8b)+z->get_spin(p9b)==z->get_spin(h7b)+z->get_spin(h10b)) { 
           if ((z->get_sym(p8b)^(z->get_sym(p9b)^(z->get_sym(h7b)^z->get_sym(h10b))))==z->irrep_t()) { 
            long p8b_0,p9b_0,h7b_0,h10b_0; 
            z->restricted_4(p8b,p9b,h7b,h10b,p8b_0,p9b_0,h7b_0,h10b_0); 
            long h4b_1,h10b_1,p5b_1,p9b_1; 
            z->restricted_4(h4b,h10b,p5b,p9b,h4b_1,h10b_1,p5b_1,p9b_1); 
            long dim_common=z->get_range(h10b)*z->get_range(p9b); 
            long dima0_sort=z->get_range(p8b)*z->get_range(h7b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p5b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p8b<p9b && h7b<h10b) { 
              z->t2()->get_block(h10b_0+z->noab()*(h7b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(h7b),z->get_range(h10b),2,0,1,3,+1.0); 
             } 
             else if (p8b<p9b && h10b<=h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(h10b),z->get_range(h7b),3,0,1,2,-1.0); 
             } 
             else if (p9b<=p8b && h7b<h10b) { 
              z->t2()->get_block(h10b_0+z->noab()*(h7b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p8b),z->get_range(h7b),z->get_range(h10b),2,1,0,3,-1.0); 
             } 
             else if (p9b<=p8b && h10b<=h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h10b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p8b),z->get_range(h10b),z->get_range(h7b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h4b<h10b && p5b<p9b) { 
              z->lambda2()->get_block(p9b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h10b_1+z->noab()*(h4b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h10b),z->get_range(p5b),z->get_range(p9b),2,0,3,1,+1.0); 
             } 
             else if (h4b<h10b && p9b<=p5b) { 
              z->lambda2()->get_block(p5b_1-z->noab()+z->nvab()*(p9b_1-z->noab()+z->nvab()*(h10b_1+z->noab()*(h4b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h10b),z->get_range(p9b),z->get_range(p5b),3,0,2,1,-1.0); 
             } 
             else if (h10b<=h4b && p5b<p9b) { 
              z->lambda2()->get_block(p9b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h10b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h4b),z->get_range(p5b),z->get_range(p9b),2,1,3,0,-1.0); 
             } 
             else if (h10b<=h4b && p9b<=p5b) { 
              z->lambda2()->get_block(p5b_1-z->noab()+z->nvab()*(p9b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h10b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h4b),z->get_range(p9b),z->get_range(p5b),3,1,2,0,+1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h4b),z->get_range(h7b),z->get_range(p8b),1,3,2,0,+1.0); 
        in[2]->add_block(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(p8b-z->noab()+z->nvab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_21(){ 
      
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  long tileoffset; 
  tileoffset=(p7b-z->noab()+z->nvab()*(p5b-z->noab())); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p7b)!=4L) { 
    if (z->get_spin(p5b)==z->get_spin(p7b)) { 
     if ((z->get_sym(p5b)^z->get_sym(p7b))==(z->irrep_t()^z->irrep_y())) { 
      long dimc=z->get_range(p5b)*z->get_range(p7b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h9b=0L;h9b<z->noab();++h9b) { 
       for (long h10b=h9b;h10b<z->noab();++h10b) { 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p5b)+z->get_spin(p8b)==z->get_spin(h9b)+z->get_spin(h10b)) { 
          if ((z->get_sym(p5b)^(z->get_sym(p8b)^(z->get_sym(h9b)^z->get_sym(h10b))))==z->irrep_t()) { 
           long p5b_0,p8b_0,h9b_0,h10b_0; 
           z->restricted_4(p5b,p8b,h9b,h10b,p5b_0,p8b_0,h9b_0,h10b_0); 
           long h9b_1,h10b_1,p7b_1,p8b_1; 
           z->restricted_4(h9b,h10b,p7b,p8b,h9b_1,h10b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b); 
           long dima0_sort=z->get_range(p5b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            if (p5b<p8b) { 
             z->t2()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(h9b),z->get_range(h10b),0,1,3,2,+1.0); 
            } 
            else if (p8b<=p5b) { 
             z->t2()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(h9b),z->get_range(h10b),1,0,3,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p7b<p8b) { 
             z->lambda2()->get_block(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p7b),z->get_range(p8b),2,3,1,0,+1.0); 
            } 
            else if (p8b<=p7b) { 
             z->lambda2()->get_block(p7b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p8b),z->get_range(p7b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            if (h9b==h10b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p7b),z->get_range(p5b),1,0,-0.5/0.5); 
      in[2]->add_block(p7b-z->noab()+z->nvab()*(p5b-z->noab()),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_5(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  long tileoffset; 
  tileoffset=(q6b-z->noab()-z->nvab()+z->ncab()*(h4b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(q6b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(q6b)) { 
     if ((z->get_sym(h4b)^z->get_sym(q6b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h4b)*z->get_range(q6b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
        if (z->get_spin(p7b)==z->get_spin(h8b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h8b))==z->irrep_t()) { 
          long p7b_0,h8b_0; 
          z->restricted_2(p7b,h8b,p7b_0,h8b_0); 
          long h4b_1,h8b_1,p7b_1,q6b_1; 
          z->restricted_4(h4b,h8b,p7b,q6b,h4b_1,h8b_1,p7b_1,q6b_1); 
          long dim_common=z->get_range(h8b)*z->get_range(p7b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h4b)*z->get_range(q6b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h8b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h8b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h4b<h8b) { 
            z->v2()->get_block(q6b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h8b),z->get_range(p7b),z->get_range(q6b),3,0,2,1,+1.0); 
           } 
           else if (h8b<=h4b) { 
            z->v2()->get_block(q6b_1+(z->nab())*(p7b_1+(z->nab())*(h4b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h4b),z->get_range(p7b),z->get_range(q6b),3,1,2,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(q6b),z->get_range(h4b),1,0,-1.0); 
      in[2]->add_block(q6b-z->noab()-z->nvab()+z->ncab()*(h4b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_6(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long q6b=z->noab()+z->nvab();q6b<z->nab();++q6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(q6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(q6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(q6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_y()^z->irrep_e())) { 
        long dimc=z->get_range(h7b)*z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(h7b)==z->get_spin(p8b)) { 
          if ((z->get_sym(h7b)^z->get_sym(p8b))==z->irrep_y()) { 
           long h7b_0,p8b_0; 
           z->restricted_2(h7b,p8b,h7b_0,p8b_0); 
           long p8b_1,q6b_1,h1b_1,h2b_1; 
           z->restricted_4(p8b,q6b,h1b,h2b,p8b_1,q6b_1,h1b_1,h2b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h7b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(q6b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->lambda1()->get_block(p8b_0-z->noab()+z->nvab()*(h7b_0),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->fr2()->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(q6b_1+(z->nab())*(p8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p8b),z->get_range(q6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(q6b),z->get_range(h7b),3,2,1,0,-1.0); 
        in[2]->add_block(h2b+z->noab()*(h1b+z->noab()*(q6b-z->noab()-z->nvab()+z->ncab()*(h7b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_9(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_e()^z->irrep_f())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long q8b=z->noab()+z->nvab();q8b<z->nab();++q8b) { 
         if (z->get_spin(p6b)+z->get_spin(q8b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(q8b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_e()) { 
           long p6b_0,q8b_0,h1b_0,h2b_0; 
           z->restricted_4(p6b,q8b,h1b,h2b,p6b_0,q8b_0,h1b_0,h2b_0); 
           long h7b_1,q8b_1; 
           z->restricted_2(h7b,q8b,h7b_1,q8b_1); 
           long dim_common=z->get_range(q8b); 
           long dima0_sort=z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->fr2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(q8b_0+(z->nab())*(p6b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(q8b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[3]->get_block(q8b_1-z->noab()-z->nvab()+z->ncab()*(h7b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(q8b),0,1,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),0,3,2,1,+1.0); 
        in[2]->add_block(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_2_9_0(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long q8b=z->noab()+z->nvab();q8b<z->nab();++q8b) { 
  long tileoffset; 
  tileoffset=(q8b-z->noab()-z->nvab()+z->ncab()*(h7b)); 
  if (in[3]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(q8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(q8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(q8b))==z->irrep_f()) { 
      long dimc=z->get_range(h7b)*z->get_range(q8b); 
      long h7b_0,q8b_0; 
      z->restricted_2(h7b,q8b,h7b_0,q8b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h7b)*z->get_range(q8b); 
      long dima0=dim_common*dima0_sort; 
      if (dima0>0L) { 
       double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
       double* k_a0=z->mem()->malloc_local_double(dima0); 
       z->f1()->get_block(q8b_0+(z->nab())*(h7b_0),k_a0); 
       z->sort_indices2(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(q8b),0,1,+1.0); 
       z->mem()->free_local_double(k_a0); 
       double* k_c=z->mem()->malloc_local_double(dimc); 
       z->sort_indices2(k_a0_sort,k_c,z->get_range(h7b),z->get_range(q8b),0,1,+1.0); 
       in[3]->add_block(q8b-z->noab()-z->nvab()+z->ncab()*(h7b),k_c); 
       z->mem()->free_local_double(k_c); 
       z->mem()->free_local_double(k_a0_sort); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::offset_smith_2_9(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long q8b=z->noab()+z->nvab();q8b<z->nab();++q8b) { 
  if (z->get_spin(h7b)==z->get_spin(q8b)) { 
   if ((z->get_sym(h7b)^z->get_sym(q8b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h7b)+z->get_spin(q8b)!=4L) { 
     in[3]->input_offset(q8b-z->noab()-z->nvab()+z->ncab()*(h7b),size); 
     size+=z->get_range(h7b)*z->get_range(q8b); 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_3_16(){ 
      
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long q8b=z->noab()+z->nvab();q8b<z->nab();++q8b) { 
  long tileoffset; 
  tileoffset=(q8b-z->noab()-z->nvab()+z->ncab()*(h7b)); 
  if (in[3]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(q8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(q8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(q8b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h7b)*z->get_range(q8b); 
      double* k_c_sort=z->mem()->malloc_local_double(dimc); 
      std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
      for (long h10b=0L;h10b<z->noab();++h10b) { 
       for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
        if (z->get_spin(p9b)==z->get_spin(h10b)) { 
         if ((z->get_sym(p9b)^z->get_sym(h10b))==z->irrep_t()) { 
          long p9b_0,h10b_0; 
          z->restricted_2(p9b,h10b,p9b_0,h10b_0); 
          long h7b_1,h10b_1,p9b_1,q8b_1; 
          z->restricted_4(h7b,h10b,p9b,q8b,h7b_1,h10b_1,p9b_1,q8b_1); 
          long dim_common=z->get_range(h10b)*z->get_range(p9b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h7b)*z->get_range(q8b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h10b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h10b),0,1,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           if (h7b<h10b) { 
            z->v2()->get_block(q8b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p9b),z->get_range(q8b),3,0,2,1,+1.0); 
           } 
           else if (h10b<=h7b) { 
            z->v2()->get_block(q8b_1+(z->nab())*(p9b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p9b),z->get_range(q8b),3,1,2,0,-1.0); 
           } 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
       } 
      } 
      double* k_c=z->mem()->malloc_local_double(dimc); 
      z->sort_indices2(k_c_sort,k_c,z->get_range(q8b),z->get_range(h7b),1,0,-1.0); 
      in[3]->add_block(q8b-z->noab()-z->nvab()+z->ncab()*(h7b),k_c); 
      z->mem()->free_local_double(k_c); 
      z->mem()->free_local_double(k_c_sort); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_SUB_R12_LEFT::smith_3_17(){ 
      
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h9b=h4b;h9b<z->noab();++h9b) { 
  for (long h7b=0L;h7b<z->noab();++h7b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(h9b+z->noab()*(h4b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h9b)+z->get_spin(h7b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(h9b)==z->get_spin(h7b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(h9b)^(z->get_sym(h7b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_y())) { 
        long dimc=z->get_range(h4b)*z->get_range(h9b)*z->get_range(h7b)*z->get_range(p5b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h7b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h7b))==z->irrep_t()) { 
           long p10b_0,h7b_0; 
           z->restricted_2(p10b,h7b,p10b_0,h7b_0); 
           long h4b_1,h9b_1,p5b_1,p10b_1; 
           z->restricted_4(h4b,h9b,p5b,p10b,h4b_1,h9b_1,p5b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h7b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h9b)*z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h7b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h7b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p5b<p10b) { 
             z->lambda2()->get_block(p10b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h9b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h9b),z->get_range(p5b),z->get_range(p10b),2,1,0,3,+1.0); 
            } 
            else if (p10b<=p5b) { 
             z->lambda2()->get_block(p5b_1-z->noab()+z->nvab()*(p10b_1-z->noab()+z->nvab()*(h9b_1+z->noab()*(h4b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h9b),z->get_range(p10b),z->get_range(p5b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h9b),z->get_range(h4b),z->get_range(h7b),2,1,3,0,-1.0); 
        in[3]->add_block(p5b-z->noab()+z->nvab()*(h7b+z->noab()*(h9b+z->noab()*(h4b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
