% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-call.R
\name{head.dtplyr_step}
\alias{head.dtplyr_step}
\alias{tail.dtplyr_step}
\title{Subset first or last rows}
\usage{
\method{head}{dtplyr_step}(x, n = 6L, ...)

\method{tail}{dtplyr_step}(x, n = 6L, ...)
}
\arguments{
\item{x}{A \code{\link[=lazy_dt]{lazy_dt()}}}

\item{n}{Number of rows to select. Can use a negative number to instead
drop rows from the other end.}

\item{...}{Passed on to \code{\link[=head]{head()}}/\code{\link[=tail]{tail()}}.}
}
\description{
These are methods for the base generics \code{\link[=head]{head()}} and \code{\link[=tail]{tail()}}. They
are not translated.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
dt <- lazy_dt(data.frame(x = 1:10))

# first three rows
head(dt, 3)
# last three rows
tail(dt, 3)

# drop first three rows
tail(dt, -3)
}
