/* SPDX-License-Identifier: BSD-2-Clause */
/*
 * Copyright 2020 Fraunhofer SIT. All rights reserved.
 */
#ifndef TCTI_SPI_HELPER_HELPER_H
#define TCTI_SPI_HELPER_HELPER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tcti-common.h"

#define TCTI_SPI_HELPER_MAGIC 0x4D5C6E8BD4811477ULL

#define TCTI_SPI_HELPER_RESP_HEADER_SIZE 6

typedef struct {
    TSS2_TCTI_COMMON_CONTEXT common;
    TSS2_TCTI_SPI_HELPER_PLATFORM platform;
    char header[TCTI_SPI_HELPER_RESP_HEADER_SIZE];
} TSS2_TCTI_SPI_HELPER_CONTEXT;

#define TCTI_SPI_HELPER_TPM_LOCALITY_0    0x00D40000
#define TCTI_SPI_HELPER_TPM_ACCESS_REG    (TCTI_SPI_HELPER_TPM_LOCALITY_0 + 0)
#define TCTI_SPI_HELPER_TPM_STS_REG       (TCTI_SPI_HELPER_TPM_LOCALITY_0 + 0x18)
#define TCTI_SPI_HELPER_TPM_DATA_FIFO_REG (TCTI_SPI_HELPER_TPM_LOCALITY_0 + 0x24)
#define TCTI_SPI_HELPER_TPM_DID_VID_REG   (TCTI_SPI_HELPER_TPM_LOCALITY_0 + 0xF00)
#define TCTI_SPI_HELPER_TPM_RID_REG       (TCTI_SPI_HELPER_TPM_LOCALITY_0 + 0xF04)

enum TCTI_SPI_HELPER_TPM_ACCESS {
    TCTI_SPI_HELPER_TPM_ACCESS_VALID = (1 << 7),
    TCTI_SPI_HELPER_TPM_ACCESS_ACTIVE_LOCALITY = (1 << 5),
    TCTI_SPI_HELPER_TPM_ACCESS_REQUEST_USE = (1 << 1)
};

enum TCTI_SPI_HELPER_TPM_STATUS {
    TCTI_SPI_HELPER_TPM_STS_BURST_COUNT_SHIFT = 8,
    TCTI_SPI_HELPER_TPM_STS_BURST_COUNT_MASK = (0xFFFF << TCTI_SPI_HELPER_TPM_STS_BURST_COUNT_SHIFT),
    TCTI_SPI_HELPER_TPM_STS_VALID = (1 << 7),
    TCTI_SPI_HELPER_TPM_STS_COMMAND_READY = (1 << 6),
    TCTI_SPI_HELPER_TPM_STS_GO = (1 << 5),
    TCTI_SPI_HELPER_TPM_STS_DATA_AVAIL = (1 << 4),
    TCTI_SPI_HELPER_TPM_STS_DATA_EXPECT = (1 << 3)
};

enum TCTI_SPI_HELPER_FIFO_TRANSFER_DIRECTION {
    TCTI_SPI_HELPER_FIFO_TRANSMIT = 0,
    TCTI_SPI_HELPER_FIFO_RECEIVE = 1
};

enum TCTI_SPI_HELPER_REGISTER_ACCESS_TYPE {
    TCTI_SPI_HELPER_REGISTER_WRITE = 0,
    TCTI_SPI_HELPER_REGISTER_READ = 1
};

#endif /* TCTI_SPI_HELPER_HELPER_H */
