from ..adapters import LinearAdapter
from construct import Adapter, BitsInteger, BitStruct, Container, Enum, Flag, \
                      Int8ub, Int16ub, Int32ub, Padding, Struct, Switch

L0 = BitStruct(
    'L0__WDT_2SEC_CNT' / BitsInteger(3),
    'L0__RESET_ARMED' / Enum(Flag, ARMED=1, NOT_ARMED=0),
    'L0__WDT_STAT' / Enum(Flag, NO_WDT=0, WDT=1),
    'L0__WDT_EN' / Enum(Flag, DISABLED=0, ENABLED=1),
    'L0__TABLE_SELECT' / Enum(Flag, FLASH=0, COMPILED=1),
    'L0__BOOT_RELAY' / Enum(Flag, PRIMARY=1, REDUNDANT=0),
    'L0__L0_ACPT_CNT' / BitsInteger(8),
    'L0__L0_RJCT_CNT' / BitsInteger(8),
    'L0__HW_SEC_CNT' / BitsInteger(8),
    Padding(64),
    'L0__TIME_TAG' / BitsInteger(32),
    Padding(32),
    'L0__PLD_TLM_ACK_CNT' / BitsInteger(8),
    'L0__PLD_CMD_CNT' / BitsInteger(8),
    'L0__PLD_TLM_TO_CNT' / BitsInteger(8),
    'L0__PLD_TLM_NAK_CNT' / BitsInteger(8),
    'L0__SPARE_END' / BitsInteger(64),
)

COMMAND_TLM = BitStruct(
    'COMMAND_TLM__CMD_STATUS' / Enum(BitsInteger(8), OK=0, BAD_APID=1,
                                     BAD_OPCODE=2, BAD_DATA=3, NOW_READING=4,
                                     DONE_READING=5, IDLE=6, NO_CMD_DATA=7,
                                     CMD_SRVC_OVERRUN=8, CMD_APID_OVERRUN=9,
                                     INCORRECT_WHEEL_MODE=10, BAD_ELEMENT=11,
                                     TABLES_BUSY=12, FLASH_NOT_ARMED=13,
                                     THRUSTERS_DISABLED=14,
                                     ATT_ERR_TOO_HIGH=15, ASYNC_REFUSED=16,
                                     DRIVER_ERROR=17),
    'COMMAND_TLM__CMD_REJECT_STATUS' / Enum(BitsInteger(8), OK=0, BAD_APID=1,
                                            BAD_OPCODE=2, BAD_DATA=3,
                                            NOW_READING=4, DONE_READING=5,
                                            IDLE=6, NO_CMD_DATA=7,
                                            CMD_SRVC_OVERRUN=8,
                                            CMD_APID_OVERRUN=9,
                                            INCORRECT_WHEEL_MODE=10,
                                            BAD_ELEMENT=11, TABLES_BUSY=12,
                                            FLASH_NOT_ARMED=13,
                                            THRUSTERS_DISABLED=14,
                                            ATT_ERR_TOO_HIGH=15,
                                            ASYNC_REFUSED=16, DRIVER_ERROR=17),
    'COMMAND_TLM__REALTIME_CMD_ACCEPT_COUNT' / BitsInteger(8),
    'COMMAND_TLM__REALTIME_CMD_REJECT_COUNT' / BitsInteger(8),
    'COMMAND_TLM__STORED_CMD_ACCEPT_COUNT' / BitsInteger(8),
    'COMMAND_TLM__STORED_CMD_REJECT_COUNT' / BitsInteger(8),
    'COMMAND_TLM__LAST_ACC_CMD_BYTES1' / BitsInteger(8),
    'COMMAND_TLM__LAST_ACC_CMD_BYTES2' / BitsInteger(8),
    'COMMAND_TLM__LAST_ACC_CMD_BYTES3' / BitsInteger(8),
    'COMMAND_TLM__LAST_ACC_CMD_BYTES4' / BitsInteger(8),
    'COMMAND_TLM__LAST_ACC_CMD_BYTES5' / BitsInteger(8),
    'COMMAND_TLM__LAST_ACC_CMD_BYTES6' / BitsInteger(8),
    'COMMAND_TLM__LAST_ACC_CMD_BYTES7' / BitsInteger(8),
    'COMMAND_TLM__LAST_ACC_CMD_BYTES8' / BitsInteger(8),
    'COMMAND_TLM__LAST_REJ_CMD_BYTES1' / BitsInteger(8),
    'COMMAND_TLM__LAST_REJ_CMD_BYTES2' / BitsInteger(8),
    'COMMAND_TLM__LAST_REJ_CMD_BYTES3' / BitsInteger(8),
    'COMMAND_TLM__LAST_REJ_CMD_BYTES4' / BitsInteger(8),
    'COMMAND_TLM__LAST_REJ_CMD_BYTES5' / BitsInteger(8),
    'COMMAND_TLM__LAST_REJ_CMD_BYTES6' / BitsInteger(8),
    'COMMAND_TLM__LAST_REJ_CMD_BYTES7' / BitsInteger(8),
    'COMMAND_TLM__LAST_REJ_CMD_BYTES8' / BitsInteger(8),
    'COMMAND_TLM__HEALTH_STATUS_INTERVAL' / BitsInteger(16),
    'COMMAND_TLM__NAV_TLM_INTERVAL' / BitsInteger(16),
    'COMMAND_TLM__STORED_TIMED_CMDS_ENABLED' / Enum(BitsInteger(8),
                                                    DS=0, EN=1),
    'COMMAND_TLM__MACROS_ENABLED' / Enum(BitsInteger(8), DS=0, EN=1),
    'COMMAND_TLM__LAST_ST_CMD_QUEUED' / BitsInteger(16),
    'COMMAND_TLM__LAST_ST_CMD_EXPIRED' / BitsInteger(16),
    'COMMAND_TLM__LAST_AUTONOMOUS_MACRO' / BitsInteger(16),
    'COMMAND_TLM__STORED_TIMED_CMDS_QUEUED' / BitsInteger(32),
    'COMMAND_TLM__STORED_TIMED_CMDS_EXPIRED' / BitsInteger(32),
    'COMMAND_TLM__MACRO_CMDS_QUEUED' / BitsInteger(32),
    'COMMAND_TLM__MACRO_CMDS_EXPIRED' / BitsInteger(32),
    'COMMAND_TLM__MACROS_EXECUTING_PACK1' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK2' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK3' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK4' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK5' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK6' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK7' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK8' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK9' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK10' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK11' / BitsInteger(8),
    'COMMAND_TLM__MACROS_EXECUTING_PACK12' / BitsInteger(8),
    'COMMAND_TLM__PACKAGE_EXEC_TIME' / BitsInteger(32),
    'COMMAND_TLM__LAST_RT_CMD_RUN_COUNT' / BitsInteger(32),
)

GENERAL = BitStruct(
    'GENERAL__SOFTWARE_VERSION1' / BitsInteger(32),
    'GENERAL__SOFTWARE_VERSION2' / BitsInteger(32),
    'GENERAL__HARDWARE_VERSION' / BitsInteger(32),
    'GENERAL__ASYNC_RUNNING' / BitsInteger(8),
    'GENERAL__SCRUB_STATUS_PART0' / Enum(BitsInteger(8), OK=0, FAIL=-1),
    'GENERAL__SCRUB_STATUS_PART1' / Enum(BitsInteger(8), OK=0, FAIL=-1),
    'GENERAL__SCRUB_STATUS_PART2' / Enum(BitsInteger(8), OK=0, FAIL=-1),
    'GENERAL__SCRUB_STATUS_PART3' / Enum(BitsInteger(8), OK=0, FAIL=-1),
    'GENERAL__SCRUB_STATUS_PART4' / Enum(BitsInteger(8), OK=0, FAIL=-1),
    'GENERAL__SCRUB_STATUS_PART5' / Enum(BitsInteger(8), OK=0, FAIL=-1),
    'GENERAL__SCRUB_STATUS_OVERALL' / Enum(BitsInteger(8), OK=0, FAIL=-1),
    'GENERAL__SCRUB_COUNT' / BitsInteger(8),
    'GENERAL__FLASH_CMD_SUCC_COUNT' / BitsInteger(8),
    'GENERAL__FLASH_CMD_FAIL_COUNT' / BitsInteger(8),
    'GENERAL__FLASH_LAST_PART' / BitsInteger(8),
    'GENERAL__FLASH_LAST_OFF' / BitsInteger(32),
    'GENERAL__FLASH_LAST_CHECK' / BitsInteger(32),
    'GENERAL__IMAGE_BOOTED' / Enum(BitsInteger(8), PRIMARY=0, REDUNDANT=1),
    'GENERAL__IMAGE_AUTO_FAILOVER' / Enum(BitsInteger(8), OK=0, FAIL=1),
    'GENERAL__INERTIA1' / LinearAdapter(10000.000300000009, BitsInteger(32)),
    'GENERAL__INERTIA2' / LinearAdapter(10000.000300000009, BitsInteger(32)),
    'GENERAL__INERTIA3' / LinearAdapter(10000.000300000009, BitsInteger(32)),
    'GENERAL__INERTIA4' / LinearAdapter(10000.000300000009, BitsInteger(32)),
    'GENERAL__INERTIA5' / LinearAdapter(10000.000300000009, BitsInteger(32)),
    'GENERAL__INERTIA6' / LinearAdapter(10000.000300000009, BitsInteger(32)),
    'GENERAL__INERTIA7' / LinearAdapter(10000.000300000009, BitsInteger(32)),
    'GENERAL__INERTIA8' / LinearAdapter(10000.000300000009, BitsInteger(32)),
    'GENERAL__INERTIA9' / LinearAdapter(10000.000300000009, BitsInteger(32)),
    'GENERAL__FS_LAST_OFF' / BitsInteger(32),
    'GENERAL__FS_LAST_LEN' / BitsInteger(32),
    'GENERAL__FS_LAST_CHECK' / BitsInteger(32),
    'GENERAL__FS_OP_STATUS' / Enum(BitsInteger(8), SUCCESS_DONE=0, IN_PROG=1,
                                   BAD_PATH=2, BAD_PARAM=3, FAILURE=4,
                                   ABORTED=5),
    'GENERAL__FS_MOUNTED' / Enum(BitsInteger(8), NOT_MOUNTED=0,
                                 PRIMARY_MOUNTED=1, REDUNDANT_MOUNTED=2,
                                 BOTH_MOUNTED=3),
    'GENERAL__FS_LAST_OP' / Enum(BitsInteger(8), FS_NONE=0, FS_WRITE=1,
                                 FS_READ=2, FS_CRC=3, FS_COPY=4, FS_DELETE=5,
                                 FS_EXECUTE=6, FS_COMPRESS=7, FS_MOUNT=8,
                                 FS_MD5SUM=9, FS_CCSDS_FILE=10),
    'GENERAL__RAM_SINGLE_BIT_ERROR_COUNT' / BitsInteger(32),
)

TIME = BitStruct(
    'TIME__TAI_SECONDS' / LinearAdapter(5.0, BitsInteger(32)),
    'TIME__CYCLE_TIME' / LinearAdapter(5.0, BitsInteger(32)),
    'TIME__JD_OF_NOW_WRT_TAI' / BitsInteger(32),
    'TIME__GPS_UPDATE_CYCLE_PERIOD' / BitsInteger(32),
    'TIME__GPS_UPDATE_CYCLE_COUNT' / BitsInteger(32),
    'TIME__TIME_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
)

REFS = BitStruct(
    'REFS__GPS_TIMER' / BitsInteger(32),
    'REFS__TIME_NOW_32' / LinearAdapter(5.0, BitsInteger(32)),
    'REFS__Q_ECEF_WRT_ECI1' / LinearAdapter(1000000030, BitsInteger(32)),
    'REFS__Q_ECEF_WRT_ECI2' / LinearAdapter(1000000030, BitsInteger(32)),
    'REFS__Q_ECEF_WRT_ECI3' / LinearAdapter(1000000030, BitsInteger(32)),
    'REFS__Q_ECEF_WRT_ECI4' / LinearAdapter(1000000030, BitsInteger(32)),
    'REFS__POSITION_WRT_ECI1' / LinearAdapter(50000, BitsInteger(32)),
    'REFS__POSITION_WRT_ECI2' / LinearAdapter(50000, BitsInteger(32)),
    'REFS__POSITION_WRT_ECI3' / LinearAdapter(50000, BitsInteger(32)),
    'REFS__POSITION_WRT_ECEF1' / LinearAdapter(50000, BitsInteger(32)),
    'REFS__POSITION_WRT_ECEF2' / LinearAdapter(50000, BitsInteger(32)),
    'REFS__POSITION_WRT_ECEF3' / LinearAdapter(50000, BitsInteger(32)),
    'REFS__VELOCITY_WRT_ECI1' / LinearAdapter(200000000, BitsInteger(32)),
    'REFS__VELOCITY_WRT_ECI2' / LinearAdapter(200000000, BitsInteger(32)),
    'REFS__VELOCITY_WRT_ECI3' / LinearAdapter(200000000, BitsInteger(32)),
    'REFS__VELOCITY_WRT_ECEF1' / LinearAdapter(200000000, BitsInteger(32)),
    'REFS__VELOCITY_WRT_ECEF2' / LinearAdapter(200000000, BitsInteger(32)),
    'REFS__VELOCITY_WRT_ECEF3' / LinearAdapter(200000000, BitsInteger(32)),
    'REFS__NADIR_VECTOR_BODY1' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__NADIR_VECTOR_BODY2' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__NADIR_VECTOR_BODY3' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MODELED_SUN_VECTOR_BODY1' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MODELED_SUN_VECTOR_BODY2' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MODELED_SUN_VECTOR_BODY3' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MOON_VECTOR_BODY1' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MOON_VECTOR_BODY2' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MOON_VECTOR_BODY3' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MAG_MODEL_VECTOR_ECI1' / LinearAdapter(200000000, BitsInteger(16)),
    'REFS__MAG_MODEL_VECTOR_ECI2' / LinearAdapter(200000000, BitsInteger(16)),
    'REFS__MAG_MODEL_VECTOR_ECI3' / LinearAdapter(200000000, BitsInteger(16)),
    'REFS__MAG_MODEL_VECTOR_BODY1' / LinearAdapter(200000000, BitsInteger(16)),
    'REFS__MAG_MODEL_VECTOR_BODY2' / LinearAdapter(200000000, BitsInteger(16)),
    'REFS__MAG_MODEL_VECTOR_BODY3' / LinearAdapter(200000000, BitsInteger(16)),
    'REFS__SUN_MODEL_VECTOR_ECI1' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__SUN_MODEL_VECTOR_ECI2' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__SUN_MODEL_VECTOR_ECI3' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MOON_MODEL_VECTOR_ECI1' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MOON_MODEL_VECTOR_ECI2' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__MOON_MODEL_VECTOR_ECI3' / LinearAdapter(25000, BitsInteger(16)),
    'REFS__ORBIT_METHOD' / Enum(BitsInteger(8), KEPLER=0, GRAVITY_POINT=1,
                                GRAVITY_J2=2, GRAVITY_HARMONIC=3, SGP4=4,
                                EXTERN_ACC_ONLY=5, POLYNOMIAL=6, GEONS=7),
    'REFS__REFS_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'REFS__ESM_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'REFS__RUN_LOW_RATE_TASK' / Enum(BitsInteger(8), YES=1, NO=0),
    'REFS__AUTO_GPS_USAGE' / Enum(BitsInteger(8), YES=1, NO=0),
)

ATT_DET = BitStruct(
    'ATT_DET__Q_BODY_WRT_ECI1' / LinearAdapter(2000000040, BitsInteger(32)),
    'ATT_DET__Q_BODY_WRT_ECI2' / LinearAdapter(2000000040, BitsInteger(32)),
    'ATT_DET__Q_BODY_WRT_ECI3' / LinearAdapter(2000000040, BitsInteger(32)),
    'ATT_DET__Q_BODY_WRT_ECI4' / LinearAdapter(2000000040, BitsInteger(32)),
    'ATT_DET__RESIDUAL1' / LinearAdapter(2000000040, BitsInteger(32)),
    'ATT_DET__RESIDUAL2' / LinearAdapter(2000000040, BitsInteger(32)),
    'ATT_DET__RESIDUAL3' / LinearAdapter(2000000040, BitsInteger(32)),
    'ATT_DET__BODY_RATE1_RPM' / LinearAdapter(20943951, BitsInteger(32)),
    'ATT_DET__BODY_RATE2_RPM' / LinearAdapter(20943951, BitsInteger(32)),
    'ATT_DET__BODY_RATE3_RPM' / LinearAdapter(20943951, BitsInteger(32)),
    'ATT_DET__GYRO_BIAS_EST1_RPM' / LinearAdapter(209439.5, BitsInteger(16)),
    'ATT_DET__GYRO_BIAS_EST2_RPM' / LinearAdapter(209439.5, BitsInteger(16)),
    'ATT_DET__GYRO_BIAS_EST3_RPM' / LinearAdapter(209439.5, BitsInteger(16)),
    'ATT_DET__ATTITUDE_ALG' / Enum(BitsInteger(8), RAW=1, FIXED_GAIN_NO_BIAS=2,
                                   FIXED_GAIN=3, MEKF=4),
    'ATT_DET__GOOD_ATT_RATE_TIMER' / BitsInteger(32),
    'ATT_DET__BAD_ATT_TIMER' / BitsInteger(32),
    'ATT_DET__BAD_RATE_TIMER' / BitsInteger(32),
    'ATT_DET__REINIT_COUNT' / BitsInteger(32),
    'ATT_DET__ATTITUDE_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'ATT_DET__MEAS_ATT_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'ATT_DET__MEAS_RATE_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'ATT_DET__TRACKER_USED' / BitsInteger(8),
    'ATT_DET__TRACKER_PREFERENCE' / BitsInteger(8),
)

ATT_CMD = BitStruct(
    'ATT_CMD__CMD_Q_BODY_WRT_ECI1' / LinearAdapter(2e9, BitsInteger(32)),
    'ATT_CMD__CMD_Q_BODY_WRT_ECI2' / LinearAdapter(2e9, BitsInteger(32)),
    'ATT_CMD__CMD_Q_BODY_WRT_ECI3' / LinearAdapter(2e9, BitsInteger(32)),
    'ATT_CMD__CMD_Q_BODY_WRT_ECI4' / LinearAdapter(2e9, BitsInteger(32)),
    'ATT_CMD__CMD_BODY_RATE1_RPM' / LinearAdapter(20943951, BitsInteger(32)),
    'ATT_CMD__CMD_BODY_RATE2_RPM' / LinearAdapter(20943951, BitsInteger(32)),
    'ATT_CMD__CMD_BODY_RATE3_RPM' / LinearAdapter(20943951, BitsInteger(32)),
    'ATT_CMD__CMD_BODY_ACCEL1' / LinearAdapter(200000000, BitsInteger(32)),
    'ATT_CMD__CMD_BODY_ACCEL2' / LinearAdapter(200000000, BitsInteger(32)),
    'ATT_CMD__CMD_BODY_ACCEL3' / LinearAdapter(200000000, BitsInteger(32)),
    'ATT_CMD__COMMANDED_SUN1' / LinearAdapter(25000, BitsInteger(16)),
    'ATT_CMD__COMMANDED_SUN2' / LinearAdapter(25000, BitsInteger(16)),
    'ATT_CMD__COMMANDED_SUN3' / LinearAdapter(25000, BitsInteger(16)),
    'ATT_CMD__HR_CYCLE_SAFE_MODE' / BitsInteger(32),
    'ATT_CMD__ROTISSERIE_RATE_RPM' / LinearAdapter(2617.9939434413427,
                                                   BitsInteger(16)),
    'ATT_CMD__ADCS_MODE' / Enum(BitsInteger(8), SUN_POINT=0, FINE_REF_POINT=1,
                                SEARCH_INIT=2, SEARCHING=3, WAITING=4,
                                CONVERGING=5, ON_SUN=6, NOT_ACTIVE=7),
    'ATT_CMD__SAFE_MODE_REASON' / Enum(BitsInteger(8), BOOT=1, COMMAND=2,
                                       ATTITUDE_INVALID=4, TIME_INVALID=8,
                                       ATTITUDE_TIME_INVALID=12,
                                       REFS_INVALID=16),
    'ATT_CMD__RECOMMEND_SUN_POINT' / Enum(BitsInteger(8), YES=1, NO=0),
)

RW_DRIVE = BitStruct(
    'RW_DRIVE__THETA_ERR1' / LinearAdapter(1000, BitsInteger(16)),
    'RW_DRIVE__THETA_ERR2' / LinearAdapter(1000, BitsInteger(16)),
    'RW_DRIVE__THETA_ERR3' / LinearAdapter(1000, BitsInteger(16)),
    'RW_DRIVE__DRAG_EST1' / LinearAdapter(100, BitsInteger(16)),
    'RW_DRIVE__DRAG_EST2' / LinearAdapter(100, BitsInteger(16)),
    'RW_DRIVE__DRAG_EST3' / LinearAdapter(100, BitsInteger(16)),
    'RW_DRIVE__OBS_ANGLE_RESIDUAL1' / LinearAdapter(4000, BitsInteger(16)),
    'RW_DRIVE__OBS_ANGLE_RESIDUAL2' / LinearAdapter(4000, BitsInteger(16)),
    'RW_DRIVE__OBS_ANGLE_RESIDUAL3' / LinearAdapter(4000, BitsInteger(16)),
    'RW_DRIVE__FILTERED_SPEED_RPM1' / LinearAdapter(2.5, BitsInteger(16)),
    'RW_DRIVE__FILTERED_SPEED_RPM2' / LinearAdapter(2.5, BitsInteger(16)),
    'RW_DRIVE__FILTERED_SPEED_RPM3' / LinearAdapter(2.5, BitsInteger(16)),
    'RW_DRIVE__SPEED_CMD_RPM1' / LinearAdapter(2.5, BitsInteger(16)),
    'RW_DRIVE__SPEED_CMD_RPM2' / LinearAdapter(2.5, BitsInteger(16)),
    'RW_DRIVE__SPEED_CMD_RPM3' / LinearAdapter(2.5, BitsInteger(16)),
    'RW_DRIVE__TORQUE_CMD1' / LinearAdapter(10000000, BitsInteger(16)),
    'RW_DRIVE__TORQUE_CMD2' / LinearAdapter(10000000, BitsInteger(16)),
    'RW_DRIVE__TORQUE_CMD3' / LinearAdapter(10000000, BitsInteger(16)),
    'RW_DRIVE__MEAS_WHEEL_CURRENT1' / LinearAdapter(1000, BitsInteger(16)),
    'RW_DRIVE__MEAS_WHEEL_CURRENT2' / LinearAdapter(1000, BitsInteger(16)),
    'RW_DRIVE__MEAS_WHEEL_CURRENT3' / LinearAdapter(1000, BitsInteger(16)),
    'RW_DRIVE__RW_TIME' / BitsInteger(32),
    'RW_DRIVE__PWM_COUNTS1' / BitsInteger(32),
    'RW_DRIVE__PWM_COUNTS2' / BitsInteger(32),
    'RW_DRIVE__PWM_COUNTS3' / BitsInteger(32),
    'RW_DRIVE__PW_MCMD_CT1' / BitsInteger(32),
    'RW_DRIVE__PW_MCMD_CT2' / BitsInteger(32),
    'RW_DRIVE__PW_MCMD_CT3' / BitsInteger(32),
    'RW_DRIVE__MOTOR_TACH_COUNTS1' / BitsInteger(16),
    'RW_DRIVE__MOTOR_TACH_COUNTS2' / BitsInteger(16),
    'RW_DRIVE__MOTOR_TACH_COUNTS3' / BitsInteger(16),
    'RW_DRIVE__SENSOR_CAL_TIMER1' / BitsInteger(16),
    'RW_DRIVE__SENSOR_CAL_TIMER2' / BitsInteger(16),
    'RW_DRIVE__SENSOR_CAL_TIMER3' / BitsInteger(16),
    'RW_DRIVE__OPERATING_MODE1' / Enum(BitsInteger(8), IDLE=0, INT=1, EXT=2),
    'RW_DRIVE__OPERATING_MODE2' / Enum(BitsInteger(8), IDLE=0, INT=1, EXT=2),
    'RW_DRIVE__OPERATING_MODE3' / Enum(BitsInteger(8), IDLE=0, INT=1, EXT=2),
    'RW_DRIVE__CONTROL_MODE1' / Enum(BitsInteger(8), TRQ=0, SPD=1, PWM=2,
                                     ISOLATE=3),
    'RW_DRIVE__CONTROL_MODE2' / Enum(BitsInteger(8), TRQ=0, SPD=1, PWM=2,
                                     ISOLATE=3),
    'RW_DRIVE__CONTROL_MODE3' / Enum(BitsInteger(8), TRQ=0, SPD=1, PWM=2,
                                     ISOLATE=3),
    'RW_DRIVE__MOTOR_FAULT1' / Enum(BitsInteger(8), FAULT=0, OK=1),
    'RW_DRIVE__MOTOR_FAULT2' / Enum(BitsInteger(8), FAULT=0, OK=1),
    'RW_DRIVE__MOTOR_FAULT3' / Enum(BitsInteger(8), FAULT=0, OK=1),
    'RW_DRIVE__MOTOR_HALL_STATE1' / BitsInteger(8),
    'RW_DRIVE__MOTOR_HALL_STATE2' / BitsInteger(8),
    'RW_DRIVE__MOTOR_HALL_STATE3' / BitsInteger(8),
    'RW_DRIVE__PW_MENABLE1' / Enum(BitsInteger(8), YES=1, NO=0),
    'RW_DRIVE__PW_MENABLE2' / Enum(BitsInteger(8), YES=1, NO=0),
    'RW_DRIVE__PW_MENABLE3' / Enum(BitsInteger(8), YES=1, NO=0),
    'RW_DRIVE__PW_MDIRECTION1' / Enum(BitsInteger(8), POS=0, NEG=1),
    'RW_DRIVE__PW_MDIRECTION2' / Enum(BitsInteger(8), POS=0, NEG=1),
    'RW_DRIVE__PW_MDIRECTION3' / Enum(BitsInteger(8), POS=0, NEG=1),
    'RW_DRIVE__PW_MCMD_DIR1' / Enum(BitsInteger(8), POS=0, NEG=1),
    'RW_DRIVE__PW_MCMD_DIR2' / Enum(BitsInteger(8), POS=0, NEG=1),
    'RW_DRIVE__PW_MCMD_DIR3' / Enum(BitsInteger(8), POS=0, NEG=1),
    'RW_DRIVE__RW_TEST_MODE' / Enum(BitsInteger(8), OFF=0, ON=1),
)

TRACKER = BitStruct(
    'TRACKER__ATTITUDE_ST1' / LinearAdapter(2048000000, BitsInteger(32)),
    'TRACKER__ATTITUDE_ST2' / LinearAdapter(2048000000, BitsInteger(32)),
    'TRACKER__ATTITUDE_ST3' / LinearAdapter(2048000000, BitsInteger(32)),
    'TRACKER__ATTITUDE_ST4' / LinearAdapter(2048000000, BitsInteger(32)),
    'TRACKER__RATE_EST1_RPM' / LinearAdapter(41887.9, BitsInteger(16)),
    'TRACKER__RATE_EST2_RPM' / LinearAdapter(41887.9, BitsInteger(16)),
    'TRACKER__RATE_EST3_RPM' / LinearAdapter(41887.9, BitsInteger(16)),
    'TRACKER__RIGHT_ASC' / LinearAdapter(181.81818181818184, BitsInteger(16)),
    'TRACKER__DECLINATION' / LinearAdapter(181.8181818181818, BitsInteger(16)),
    'TRACKER__ROLL' / LinearAdapter(181.81818181818184, BitsInteger(16)),
    'TRACKER__ATT_COVARIANCE1' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER__ATT_COVARIANCE2' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER__ATT_COVARIANCE3' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER__ATT_COVARIANCE4' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER__ATT_COVARIANCE5' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER__ATT_COVARIANCE6' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER__MAXIMUM_RESIDUAL' / BitsInteger(8),
    'TRACKER__MAXIMUM_RESIDUAL_INIT' / BitsInteger(8),
    'TRACKER__ANALOG_GAIN_EU' / LinearAdapter(2.0, BitsInteger(8)),
    'TRACKER__MAG_BRIGHT' / LinearAdapter(25, BitsInteger(8)),
    'TRACKER__MAG_DIM' / LinearAdapter(25, BitsInteger(8)),
    'TRACKER__PEAK_NOISE_ALL_TRK_BLKS' / LinearAdapter(0.25, BitsInteger(8)),
    'TRACKER__PEAK_BCKGND_ALL_TRK_BLKS' / LinearAdapter(0.25, BitsInteger(8)),
    'TRACKER__MEDIAN_NOISE_ALL_TRK_BLKS' / LinearAdapter(0.25, BitsInteger(8)),
    'TRACKER__MEDIAN_BCKGND_ALL_TRK_BLKS' / LinearAdapter(0.25,
                                                          BitsInteger(8)),
    'TRACKER__FOV_RATE_X_RPM' / LinearAdapter(20943.95, BitsInteger(16)),
    'TRACKER__FOV_RATE_Y_RPM' / LinearAdapter(20943.95, BitsInteger(16)),
    'TRACKER__OPERATING_MODE' / Enum(BitsInteger(8), IDLE=0, INITIALIZE=1,
                                     STARID=2, TRACK=3, PHOTO=4, CAL=5),
    'TRACKER__STAR_ID_STEP' / Enum(BitsInteger(8), IDLE=0, INITIALIZE=1,
                                   WAITING_FOR_IMAGE1=2, WAITING_FOR_IMAGE2=3,
                                   CALCULATE_RATE=4, MAKE_UNIT_VECTORS=5,
                                   AWAITING_TRISTAR=6, OK_FOUND_4=7,
                                   OK_FOUND_3=8, TIME_OUT=9, SPARE=10,
                                   NO_MATCH=11),
    'TRACKER__ID_STATUS' / Enum(BitsInteger(8), IDLE=0, INITIALIZE=1,
                                WAITING_FOR_IMAGE1=2, WAITING_FOR_IMAGE2=3,
                                CALCULATE_RATE=4, MAKE_UNIT_VECTORS=5,
                                AWAITING_TRISTAR=6, OK_FOUND_4=7, OK_FOUND_3=8,
                                TIME_OUT=9, SPARE=10, NO_MATCH=11),
    'TRACKER__ID_STATUS_SAVE' / Enum(BitsInteger(8), IDLE=0, INITIALIZE=1,
                                     WAITING_FOR_IMAGE1=2,
                                     WAITING_FOR_IMAGE2=3, CALCULATE_RATE=4,
                                     MAKE_UNIT_VECTORS=5, AWAITING_TRISTAR=6,
                                     OK_FOUND_4=7, OK_FOUND_3=8, TIME_OUT=9,
                                     SPARE=10, NO_MATCH=11),
    'TRACKER__ATT_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                 TOO_FEW_STARS=3, QUEST_FAILED=4,
                                 RESIDUALS_TOO_HIGH=5, TOO_CLOSE_TO_EDGE=6,
                                 PIX_AMP_TOO_LOW=7, PIX_AMP_TOO_HIGH=8,
                                 BACKGND_TOO_HIGH=9, TRACK_FAILURE=10,
                                 PIX_SUM_TOO_LOW=11, UNUSED=12,
                                 TOO_DIM_FOR_STARID=13, TOO_MANY_GROUPS=14,
                                 TOO_FEW_GROUPS=15, CHANNEL_DISABLED=16,
                                 TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                 TOO_CLOSE_TO_OTHER=19, TOO_MANY_PIXELS=20,
                                 TOO_MANY_COLUMNS=21, TOO_MANY_ROWS=22,
                                 OPEN=23, CLOSED=24, RATE_TOO_HIGH=25),
    'TRACKER__RATE_EST_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                      TOO_FEW_STARS=3, QUEST_FAILED=4,
                                      RESIDUALS_TOO_HIGH=5,
                                      TOO_CLOSE_TO_EDGE=6, PIX_AMP_TOO_LOW=7,
                                      PIX_AMP_TOO_HIGH=8, BACKGND_TOO_HIGH=9,
                                      TRACK_FAILURE=10, PIX_SUM_TOO_LOW=11,
                                      UNUSED=12, TOO_DIM_FOR_STARID=13,
                                      TOO_MANY_GROUPS=14, TOO_FEW_GROUPS=15,
                                      CHANNEL_DISABLED=16,
                                      TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                      TOO_CLOSE_TO_OTHER=19,
                                      TOO_MANY_PIXELS=20, TOO_MANY_COLUMNS=21,
                                      TOO_MANY_ROWS=22, OPEN=23, CLOSED=24,
                                      RATE_TOO_HIGH=25),
    'TRACKER__RATE_AID_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                      TOO_FEW_STARS=3, QUEST_FAILED=4,
                                      RESIDUALS_TOO_HIGH=5,
                                      TOO_CLOSE_TO_EDGE=6, PIX_AMP_TOO_LOW=7,
                                      PIX_AMP_TOO_HIGH=8, BACKGND_TOO_HIGH=9,
                                      TRACK_FAILURE=10, PIX_SUM_TOO_LOW=11,
                                      UNUSED=12, TOO_DIM_FOR_STARID=13,
                                      TOO_MANY_GROUPS=14, TOO_FEW_GROUPS=15,
                                      CHANNEL_DISABLED=16,
                                      TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                      TOO_CLOSE_TO_OTHER=19,
                                      TOO_MANY_PIXELS=20, TOO_MANY_COLUMNS=21,
                                      TOO_MANY_ROWS=22, OPEN=23, CLOSED=24,
                                      RATE_TOO_HIGH=25),
    'TRACKER__VEL_AID_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                     TOO_FEW_STARS=3, QUEST_FAILED=4,
                                     RESIDUALS_TOO_HIGH=5, TOO_CLOSE_TO_EDGE=6,
                                     PIX_AMP_TOO_LOW=7, PIX_AMP_TOO_HIGH=8,
                                     BACKGND_TOO_HIGH=9, TRACK_FAILURE=10,
                                     PIX_SUM_TOO_LOW=11, UNUSED=12,
                                     TOO_DIM_FOR_STARID=13, TOO_MANY_GROUPS=14,
                                     TOO_FEW_GROUPS=15, CHANNEL_DISABLED=16,
                                     TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                     TOO_CLOSE_TO_OTHER=19, TOO_MANY_PIXELS=20,
                                     TOO_MANY_COLUMNS=21, TOO_MANY_ROWS=22,
                                     OPEN=23, CLOSED=24, RATE_TOO_HIGH=25),
    'TRACKER__ATT_AID_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                     TOO_FEW_STARS=3, QUEST_FAILED=4,
                                     RESIDUALS_TOO_HIGH=5, TOO_CLOSE_TO_EDGE=6,
                                     PIX_AMP_TOO_LOW=7, PIX_AMP_TOO_HIGH=8,
                                     BACKGND_TOO_HIGH=9, TRACK_FAILURE=10,
                                     PIX_SUM_TOO_LOW=11, UNUSED=12,
                                     TOO_DIM_FOR_STARID=13, TOO_MANY_GROUPS=14,
                                     TOO_FEW_GROUPS=15, CHANNEL_DISABLED=16,
                                     TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                     TOO_CLOSE_TO_OTHER=19, TOO_MANY_PIXELS=20,
                                     TOO_MANY_COLUMNS=21, TOO_MANY_ROWS=22,
                                     OPEN=23, CLOSED=24, RATE_TOO_HIGH=25),
    'TRACKER__VECTOR_AID_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                        TOO_FEW_STARS=3, QUEST_FAILED=4,
                                        RESIDUALS_TOO_HIGH=5,
                                        TOO_CLOSE_TO_EDGE=6, PIX_AMP_TOO_LOW=7,
                                        PIX_AMP_TOO_HIGH=8, BACKGND_TOO_HIGH=9,
                                        TRACK_FAILURE=10, PIX_SUM_TOO_LOW=11,
                                        UNUSED=12, TOO_DIM_FOR_STARID=13,
                                        TOO_MANY_GROUPS=14, TOO_FEW_GROUPS=15,
                                        CHANNEL_DISABLED=16,
                                        TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                        TOO_CLOSE_TO_OTHER=19,
                                        TOO_MANY_PIXELS=20,
                                        TOO_MANY_COLUMNS=21, TOO_MANY_ROWS=22,
                                        OPEN=23, CLOSED=24, RATE_TOO_HIGH=25),
    'TRACKER__ATT_TIME_TAG' / BitsInteger(32),
    'TRACKER__NUM_ID_PATTERNS_TRIED' / BitsInteger(32),
    'TRACKER__PIXEL_AMP_THRESHOLD' / LinearAdapter(0.25, BitsInteger(8)),
    'TRACKER__AMPLITUDE_OFFSET' / BitsInteger(8),
    'TRACKER__CURRENT_TINT' / BitsInteger(32),
    'TRACKER__VIDEO_ADDRESS' / BitsInteger(32),
    'TRACKER__MAXIMUM_RESIDUAL_ID' / BitsInteger(16),
    'TRACKER__MAXIMUM_RESIDUAL_ID_INIT' / BitsInteger(16),
    'TRACKER__MAX_ROW_BCKGND_POST_COMP' / BitsInteger(16),
    'TRACKER__NUM_PIX_GROUPS_FOR_ID' / BitsInteger(8),
    'TRACKER__ID_TOLERANCE' / BitsInteger(8),
    'TRACKER__NUM_OF_ATT_LOOPS' / BitsInteger(8),
    'TRACKER__NUM_ATTITUDE_STARS' / BitsInteger(8),
    'TRACKER__NUM_STARS_HIGH_RESIDUAL' / BitsInteger(8),
    'TRACKER__AUTO_BLACK_ENABLE' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER__BLACK_LEVEL' / BitsInteger(8),
    'TRACKER__NUM_STARS_ON_FOV' / BitsInteger(8),
    'TRACKER__NUM_TRACK_BLOCKS_ISSUED' / BitsInteger(8),
    'TRACKER__NUM_TRACK_STARS' / BitsInteger(8),
    'TRACKER__NUM_ID_STARS' / BitsInteger(8),
    'TRACKER__FS_WCOUNTER' / BitsInteger(8),
    'TRACKER__AUTO_TRACK' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER__AUTO_INTEGRATION' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER__AUTO_GAIN' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER__TEST_MODE' / BitsInteger(8),
    'TRACKER__FPGA_DET_TIMEOUT' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER__STORE_SEQ_IMAGES' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER__TRACK_REF_AVAILABLE' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER__IMAGE_INDEX' / BitsInteger(8),
    'TRACKER__REF_INDEX' / BitsInteger(8),
    'TRACKER__NUM_BRIGHT_STARS' / BitsInteger(8),
    'TRACKER__IMAGE_FILTER_ENABLED' / BitsInteger(8),
)

ATT_CTRL = BitStruct(
    'ATT_CTRL__POSITION_ERROR1' / LinearAdapter(5e8, BitsInteger(32)),
    'ATT_CTRL__POSITION_ERROR2' / LinearAdapter(5e8, BitsInteger(32)),
    'ATT_CTRL__POSITION_ERROR3' / LinearAdapter(5e8, BitsInteger(32)),
    'ATT_CTRL__RATE_ERROR1_RPM' / LinearAdapter(20943951, BitsInteger(32)),
    'ATT_CTRL__RATE_ERROR2_RPM' / LinearAdapter(20943951, BitsInteger(32)),
    'ATT_CTRL__RATE_ERROR3_RPM' / LinearAdapter(20943951, BitsInteger(32)),
    'ATT_CTRL__INTEGRAL_ERROR1' / LinearAdapter(100000, BitsInteger(16)),
    'ATT_CTRL__INTEGRAL_ERROR2' / LinearAdapter(100000, BitsInteger(16)),
    'ATT_CTRL__INTEGRAL_ERROR3' / LinearAdapter(100000, BitsInteger(16)),
    'ATT_CTRL__MAX_RATE1_RPM' / LinearAdapter(523.5988, BitsInteger(16)),
    'ATT_CTRL__MAX_RATE2_RPM' / LinearAdapter(523.5988, BitsInteger(16)),
    'ATT_CTRL__MAX_RATE3_RPM' / LinearAdapter(523.5988, BitsInteger(16)),
    'ATT_CTRL__MAX_ACCEL1' / LinearAdapter(5000, BitsInteger(16)),
    'ATT_CTRL__MAX_ACCEL2' / LinearAdapter(5000, BitsInteger(16)),
    'ATT_CTRL__MAX_ACCEL3' / LinearAdapter(5000, BitsInteger(16)),
    'ATT_CTRL__FEEDBACK_CTRL_TORQ1' / LinearAdapter(5000000, BitsInteger(16)),
    'ATT_CTRL__FEEDBACK_CTRL_TORQ2' / LinearAdapter(5000000, BitsInteger(16)),
    'ATT_CTRL__FEEDBACK_CTRL_TORQ3' / LinearAdapter(5000000, BitsInteger(16)),
    'ATT_CTRL__CTRL_TORQUE1' / LinearAdapter(5000000, BitsInteger(16)),
    'ATT_CTRL__CTRL_TORQUE2' / LinearAdapter(5000000, BitsInteger(16)),
    'ATT_CTRL__CTRL_TORQUE3' / LinearAdapter(5000000, BitsInteger(16)),
    'ATT_CTRL__TIME_INTO_SEARCH' / BitsInteger(16),
    'ATT_CTRL__WAIT_TIMER' / BitsInteger(16),
    'ATT_CTRL__SUN_POINT_ANGLE_ERROR' / LinearAdapter(333.3334,
                                                      BitsInteger(16)),
    'ATT_CTRL__SUN_POINT_STATE' / Enum(BitsInteger(8), SUN_POINT=0,
                                       FINE_REF_POINT=1, SEARCH_INIT=2,
                                       SEARCHING=3, WAITING=4, CONVERGING=5,
                                       ON_SUN=6, NOT_ACTIVE=7),
    'ATT_CTRL__GAIN_INDEX' / BitsInteger(8),
    'ATT_CTRL__MOMENTUM_TOO_HIGH' / Enum(BitsInteger(8), YES=1, NO=0),
)

MOMENTUM = BitStruct(
    'MOMENTUM__MOMENTUM_VECTOR_BODY1' / LinearAdapter(5000, BitsInteger(16)),
    'MOMENTUM__MOMENTUM_VECTOR_BODY2' / LinearAdapter(5000, BitsInteger(16)),
    'MOMENTUM__MOMENTUM_VECTOR_BODY3' / LinearAdapter(5000, BitsInteger(16)),
    'MOMENTUM__WHEEL_MOMENTUM_BODY1' / LinearAdapter(5000, BitsInteger(16)),
    'MOMENTUM__WHEEL_MOMENTUM_BODY2' / LinearAdapter(5000, BitsInteger(16)),
    'MOMENTUM__WHEEL_MOMENTUM_BODY3' / LinearAdapter(5000, BitsInteger(16)),
    'MOMENTUM__BUS_MOMENTUM_BODY1' / LinearAdapter(5000, BitsInteger(16)),
    'MOMENTUM__BUS_MOMENTUM_BODY2' / LinearAdapter(5000, BitsInteger(16)),
    'MOMENTUM__BUS_MOMENTUM_BODY3' / LinearAdapter(5000, BitsInteger(16)),
    'MOMENTUM__CMD_MOMENTUM_INERTIAL1' / LinearAdapter(5e5, BitsInteger(16)),
    'MOMENTUM__CMD_MOMENTUM_INERTIAL2' / LinearAdapter(5e5, BitsInteger(16)),
    'MOMENTUM__CMD_MOMENTUM_INERTIAL3' / LinearAdapter(5e5, BitsInteger(16)),
    'MOMENTUM__DUTY_CYCLE1' / BitsInteger(8),
    'MOMENTUM__DUTY_CYCLE2' / BitsInteger(8),
    'MOMENTUM__DUTY_CYCLE3' / BitsInteger(8),
    'MOMENTUM__CYCLE_AVG_MAGNET_TORQUE1' / LinearAdapter(5e7, BitsInteger(16)),
    'MOMENTUM__CYCLE_AVG_MAGNET_TORQUE2' / LinearAdapter(5e7, BitsInteger(16)),
    'MOMENTUM__CYCLE_AVG_MAGNET_TORQUE3' / LinearAdapter(5e7, BitsInteger(16)),
    'MOMENTUM__TORQUE_ROD_MODE1' / Enum(BitsInteger(8), OFF=0, ON_POS=1,
                                        ON_NEG=2, AUTO=3, MEASURED=4,
                                        MODELED=5, DELAYED_AUTO=6,
                                        NO_FIELD_VALID=7),
    'MOMENTUM__TORQUE_ROD_MODE2' / Enum(BitsInteger(8), OFF=0, ON_POS=1,
                                        ON_NEG=2, AUTO=3, MEASURED=4,
                                        MODELED=5, DELAYED_AUTO=6,
                                        NO_FIELD_VALID=7),
    'MOMENTUM__TORQUE_ROD_MODE3' / Enum(BitsInteger(8), OFF=0, ON_POS=1,
                                        ON_NEG=2, AUTO=3, MEASURED=4,
                                        MODELED=5, DELAYED_AUTO=6,
                                        NO_FIELD_VALID=7),
    'MOMENTUM__MAG_SOURCE_SETTING' / Enum(BitsInteger(8), OFF=0, ON_POS=1,
                                          ON_NEG=2, AUTO=3, MEASURED=4,
                                          MODELED=5, DELAYED_AUTO=6,
                                          NO_FIELD_VALID=7),
    'MOMENTUM__MAG_SOURCE_USED' / Enum(BitsInteger(8), OFF=0, ON_POS=1,
                                       ON_NEG=2, AUTO=3, MEASURED=4, MODELED=5,
                                       DELAYED_AUTO=6, NO_FIELD_VALID=7),
    'MOMENTUM__MOMENTUM_VECTOR_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'MOMENTUM__MOMENTUM_VECTOR_ENABLED' / Enum(BitsInteger(8), YES=1, NO=0),
    'MOMENTUM__TORQUE_ROD_ENABLE1' / Enum(BitsInteger(8), DS=0, EN=1),
    'MOMENTUM__TORQUE_ROD_ENABLE2' / Enum(BitsInteger(8), DS=0, EN=1),
    'MOMENTUM__TORQUE_ROD_ENABLE3' / Enum(BitsInteger(8), DS=0, EN=1),
    'MOMENTUM__TORQUE_ROD_DIRECTION1' / Enum(BitsInteger(8), POS=0, NEG=1),
    'MOMENTUM__TORQUE_ROD_DIRECTION2' / Enum(BitsInteger(8), POS=0, NEG=1),
    'MOMENTUM__TORQUE_ROD_DIRECTION3' / Enum(BitsInteger(8), POS=0, NEG=1),
)

CSS = BitStruct(
    'CSS__SUN_VECTOR_BODY1' / LinearAdapter(10000, BitsInteger(16)),
    'CSS__SUN_VECTOR_BODY2' / LinearAdapter(10000, BitsInteger(16)),
    'CSS__SUN_VECTOR_BODY3' / LinearAdapter(10000, BitsInteger(16)),
    'CSS__SUN_VECTOR_STATUS' / Enum(BitsInteger(8), GOOD=0, COARSE=1, BAD=2),
    'CSS__NUM_DIODES_USED1' / BitsInteger(8),
    'CSS__NUM_DIODES_USED2' / BitsInteger(8),
    'CSS__NUM_DIODES_USED3' / BitsInteger(8),
    'CSS__RAW_SUN_SENSOR_DATA1' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA2' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA3' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA4' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA5' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA6' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA7' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA8' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA9' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA10' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA11' / BitsInteger(16),
    'CSS__RAW_SUN_SENSOR_DATA12' / BitsInteger(16),
    'CSS__SUN_VECTOR_ENABLED' / Enum(BitsInteger(8), YES=1, NO=0),
    'CSS__SUN_SENSOR_USED' / BitsInteger(8),
    'CSS__CSS_TEST_MODE' / Enum(BitsInteger(8), YES=1, NO=0),
)

MAG = BitStruct(
    'MAG__MAG_VECTOR_BODY1' / LinearAdapter(200000000, BitsInteger(16)),
    'MAG__MAG_VECTOR_BODY2' / LinearAdapter(200000000, BitsInteger(16)),
    'MAG__MAG_VECTOR_BODY3' / LinearAdapter(200000000, BitsInteger(16)),
    'MAG__RAW_MAGNETOMETER_DATA1' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA2' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA3' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA4' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA5' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA6' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA7' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA8' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA9' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA10' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA11' / BitsInteger(16),
    'MAG__RAW_MAGNETOMETER_DATA12' / BitsInteger(16),
    'MAG__MAG_VECTOR_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'MAG__MAG_SENSOR_USED' / BitsInteger(8),
    'MAG__MAG_TEST_MODE' / Enum(BitsInteger(8), YES=1, NO=0),
)

IMU = BitStruct(
    'IMU__AVG_CHANNEL_RATES1_RPM' / LinearAdapter(10471.98, BitsInteger(16)),
    'IMU__AVG_CHANNEL_RATES2_RPM' / LinearAdapter(10471.98, BitsInteger(16)),
    'IMU__AVG_CHANNEL_RATES3_RPM' / LinearAdapter(10471.98, BitsInteger(16)),
    'IMU__IMU_AVG_VECTOR_BODY1_RPM' / LinearAdapter(10471.98, BitsInteger(16)),
    'IMU__IMU_AVG_VECTOR_BODY2_RPM' / LinearAdapter(10471.98, BitsInteger(16)),
    'IMU__IMU_AVG_VECTOR_BODY3_RPM' / LinearAdapter(10471.98, BitsInteger(16)),
    'IMU__AVG_TIME_TAG' / BitsInteger(32),
    'IMU__RAW_FIRST_PACKET_RATES1' / BitsInteger(16),
    'IMU__RAW_FIRST_PACKET_RATES2' / BitsInteger(16),
    'IMU__RAW_FIRST_PACKET_RATES3' / BitsInteger(16),
    'IMU__IMU_INVALID_COUNT' / BitsInteger(16),
    'IMU__NEW_PACKET_COUNT' / BitsInteger(8),
    'IMU__FIRST_PACKET_ID' / BitsInteger(8),
    'IMU__IMU_VECTOR_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'IMU__IMU_VECTOR_ENABLED' / Enum(BitsInteger(8), YES=1, NO=0),
    'IMU__IMU_TEST_MODE' / Enum(BitsInteger(8), YES=1, NO=0),
)

CLOCK_SYNC = BitStruct(
    'CLOCK_SYNC__COUNTS_PER_SEC' / BitsInteger(32),
    'CLOCK_SYNC__GPS_PPS_TIME_USEC' / BitsInteger(32),
    'CLOCK_SYNC__HR_RUN_COUNT' / BitsInteger(32),
    'CLOCK_SYNC__HR_TIME_USEC' / BitsInteger(32),
    'CLOCK_SYNC__HR_CYCLE_NUM' / BitsInteger(32),
    'CLOCK_SYNC__VHR_CYCLE_NUM' / BitsInteger(32),
    'CLOCK_SYNC__HR_EXEC_TIME_MS1' / BitsInteger(8),
    'CLOCK_SYNC__HR_EXEC_TIME_MS2' / BitsInteger(8),
    'CLOCK_SYNC__HR_EXEC_TIME_MS3' / BitsInteger(8),
    'CLOCK_SYNC__HR_EXEC_TIME_MS4' / BitsInteger(8),
    'CLOCK_SYNC__HR_EXEC_TIME_MS5' / BitsInteger(8),
    'CLOCK_SYNC__CLOCK_SYNC_ENABLE' / Enum(BitsInteger(8), DS=0, EN=1,
                                           SLOPE_ONLY=2),
)

PAYLOAD = BitStruct(
    'PAYLOAD__PAYLOAD_SEC_SINCE_LAST_TLM' / BitsInteger(32),
    'PAYLOAD__PAYLOAD_TLM_RX_COUNT' / BitsInteger(16),
    'PAYLOAD__PAYLOAD_TLM_ACK_COUNT' / BitsInteger(16),
    'PAYLOAD__PAYLOAD_TLM_NAK_COUNT' / BitsInteger(16),
    'PAYLOAD__PAYLOAD_TLM_TIMEOUT_COUNT' / BitsInteger(16),
)

TLM_PROC = BitStruct(
    'TLM_PROC__TLM_TABLE_USED' / BitsInteger(8),
    'TLM_PROC__FILE_POINTER' / BitsInteger(32),
    'TLM_PROC__BUFFER_INDEX' / BitsInteger(8),
    'TLM_PROC__STREAMING' / Enum(BitsInteger(8), YES=1, NO=0),
)

ANALOGS = BitStruct(
    'ANALOGS__VOLTAGE_12P0' / LinearAdapter(10.0, BitsInteger(8)),
    'ANALOGS__VOLTAGE_8P0' / LinearAdapter(10.0, BitsInteger(8)),
    'ANALOGS__VOLTAGE_5P0' / LinearAdapter(40.0, BitsInteger(8)),
    'ANALOGS__VOLTAGE_3P3' / LinearAdapter(66.66666, BitsInteger(8)),
    'ANALOGS__DET_TEMP' / LinearAdapter(1.25, BitsInteger(8)),
    'ANALOGS__DET2_TEMP' / LinearAdapter(1.25, BitsInteger(8)),
    'ANALOGS__BOX1_TEMP' / LinearAdapter(200, BitsInteger(16)),
    'ANALOGS__MOTOR1_TEMP' / LinearAdapter(200, BitsInteger(16)),
    'ANALOGS__MOTOR2_TEMP' / LinearAdapter(200, BitsInteger(16)),
    'ANALOGS__MOTOR3_TEMP' / LinearAdapter(200, BitsInteger(16)),
    'ANALOGS__BUS_VOLTAGE' / LinearAdapter(1000, BitsInteger(16)),
    'ANALOGS__BATTERY_VOLTAGE' / LinearAdapter(500, BitsInteger(16)),
    'ANALOGS__BATTERY_CURRENT' / LinearAdapter(500, BitsInteger(16)),
    'ANALOGS__BATTERY1_TEMP' / LinearAdapter(200, BitsInteger(16)),
    'ANALOGS__BATTERY2_TEMP' / LinearAdapter(200, BitsInteger(16)),
    'ANALOGS__RADIO_TEMP' / LinearAdapter(200, BitsInteger(16)),
    'ANALOGS__USER_ANALOG1' / LinearAdapter(2000, BitsInteger(32)),
    'ANALOGS__USER_ANALOG2' / LinearAdapter(2000, BitsInteger(32)),
)

TABLES = BitStruct(
    'TABLES__LENGTH32' / BitsInteger(32),
    'TABLES__OFFSET32' / BitsInteger(32),
    'TABLES__CHECKSUM' / BitsInteger(16),
    'TABLES__TABLE_UPLOAD_STATUS' / Enum(BitsInteger(8), NEW_DATA_IN=0,
                                         COMMITTING=1, COMMITTED=2,
                                         EXTRACTING=3, EXTRACTED=4,
                                         CALCULATING_CRC=5, CRC_READY=6,
                                         INVALID_TABLE=7, IDLE=8,
                                         FLASH_BURN_COPY=9,
                                         FLASH_BURN_DIRECT=10,
                                         FLASH_EXTRACT=11, FLASH_BURN_DONE=12,
                                         FLASH_EXTRACT_DONE=13),
    'TABLES__WHICH_TABLE' / BitsInteger(8),
    'TABLES__IMAGE' / BitsInteger(8),
    'TABLES__FLASH_BURN_ARMED' / Enum(BitsInteger(8), YES=1, NO=0),
)

TRACKER2 = BitStruct(
    'TRACKER2__ATTITUDE_ST1' / LinearAdapter(2048000000, BitsInteger(32)),
    'TRACKER2__ATTITUDE_ST2' / LinearAdapter(2048000000, BitsInteger(32)),
    'TRACKER2__ATTITUDE_ST3' / LinearAdapter(2048000000, BitsInteger(32)),
    'TRACKER2__ATTITUDE_ST4' / LinearAdapter(2048000000, BitsInteger(32)),
    'TRACKER2__RATE_EST1_RPM' / LinearAdapter(41887.9, BitsInteger(16)),
    'TRACKER2__RATE_EST2_RPM' / LinearAdapter(41887.9, BitsInteger(16)),
    'TRACKER2__RATE_EST3_RPM' / LinearAdapter(41887.9, BitsInteger(16)),
    'TRACKER2__RIGHT_ASC' / LinearAdapter(181.81818181818184, BitsInteger(16)),
    'TRACKER2__DECLINATION' / LinearAdapter(181.818181818181, BitsInteger(16)),
    'TRACKER2__ROLL' / LinearAdapter(181.81818181818184, BitsInteger(16)),
    'TRACKER2__ATT_COVARIANCE1' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER2__ATT_COVARIANCE2' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER2__ATT_COVARIANCE3' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER2__ATT_COVARIANCE4' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER2__ATT_COVARIANCE5' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER2__ATT_COVARIANCE6' / LinearAdapter(6.8e13, BitsInteger(32)),
    'TRACKER2__MAXIMUM_RESIDUAL' / BitsInteger(8),
    'TRACKER2__MAXIMUM_RESIDUAL_INIT' / BitsInteger(8),
    'TRACKER2__ANALOG_GAIN_EU' / LinearAdapter(2.0, BitsInteger(8)),
    'TRACKER2__MAG_BRIGHT' / LinearAdapter(25, BitsInteger(8)),
    'TRACKER2__MAG_DIM' / LinearAdapter(25, BitsInteger(8)),
    'TRACKER2__PEAK_NOISE_ALL_TRK_BLKS' / LinearAdapter(0.25, BitsInteger(8)),
    'TRACKER2__PEAK_BCKGND_ALL_TRK_BLKS' / LinearAdapter(0.25, BitsInteger(8)),
    'TRACKER2__MEDIAN_NOISE_ALL_TRK_BLKS' / LinearAdapter(0.25,
                                                          BitsInteger(8)),
    'TRACKER2__MEDIAN_BCKGND_ALL_TRK_BLKS' / LinearAdapter(0.25,
                                                           BitsInteger(8)),
    'TRACKER2__FOV_RATE_X_RPM' / LinearAdapter(20943.9, BitsInteger(16)),
    'TRACKER2__FOV_RATE_Y_RPM' / LinearAdapter(20943.9, BitsInteger(16)),
    'TRACKER2__OPERATING_MODE' / Enum(BitsInteger(8), IDLE=0, INITIALIZE=1,
                                      STARID=2, TRACK=3, PHOTO=4, CAL=5),
    'TRACKER2__STAR_ID_STEP' / Enum(BitsInteger(8), IDLE=0, INITIALIZE=1,
                                    WAITING_FOR_IMAGE1=2, WAITING_FOR_IMAGE2=3,
                                    CALCULATE_RATE=4, MAKE_UNIT_VECTORS=5,
                                    AWAITING_TRISTAR=6, OK_FOUND_4=7,
                                    OK_FOUND_3=8, TIME_OUT=9, SPARE=10,
                                    NO_MATCH=11),
    'TRACKER2__ID_STATUS' / Enum(BitsInteger(8), IDLE=0, INITIALIZE=1,
                                 WAITING_FOR_IMAGE1=2, WAITING_FOR_IMAGE2=3,
                                 CALCULATE_RATE=4, MAKE_UNIT_VECTORS=5,
                                 AWAITING_TRISTAR=6, OK_FOUND_4=7,
                                 OK_FOUND_3=8, TIME_OUT=9, SPARE=10,
                                 NO_MATCH=11),
    'TRACKER2__ID_STATUS_SAVE' / Enum(BitsInteger(8), IDLE=0, INITIALIZE=1,
                                      WAITING_FOR_IMAGE1=2,
                                      WAITING_FOR_IMAGE2=3, CALCULATE_RATE=4,
                                      MAKE_UNIT_VECTORS=5, AWAITING_TRISTAR=6,
                                      OK_FOUND_4=7, OK_FOUND_3=8, TIME_OUT=9,
                                      SPARE=10, NO_MATCH=11),
    'TRACKER2__ATT_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                  TOO_FEW_STARS=3, QUEST_FAILED=4,
                                  RESIDUALS_TOO_HIGH=5, TOO_CLOSE_TO_EDGE=6,
                                  PIX_AMP_TOO_LOW=7, PIX_AMP_TOO_HIGH=8,
                                  BACKGND_TOO_HIGH=9, TRACK_FAILURE=10,
                                  PIX_SUM_TOO_LOW=11, UNUSED=12,
                                  TOO_DIM_FOR_STARID=13, TOO_MANY_GROUPS=14,
                                  TOO_FEW_GROUPS=15, CHANNEL_DISABLED=16,
                                  TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                  TOO_CLOSE_TO_OTHER=19, TOO_MANY_PIXELS=20,
                                  TOO_MANY_COLUMNS=21, TOO_MANY_ROWS=22,
                                  OPEN=23, CLOSED=24, RATE_TOO_HIGH=25),
    'TRACKER2__RATE_EST_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                       TOO_FEW_STARS=3, QUEST_FAILED=4,
                                       RESIDUALS_TOO_HIGH=5,
                                       TOO_CLOSE_TO_EDGE=6, PIX_AMP_TOO_LOW=7,
                                       PIX_AMP_TOO_HIGH=8, BACKGND_TOO_HIGH=9,
                                       TRACK_FAILURE=10, PIX_SUM_TOO_LOW=11,
                                       UNUSED=12, TOO_DIM_FOR_STARID=13,
                                       TOO_MANY_GROUPS=14, TOO_FEW_GROUPS=15,
                                       CHANNEL_DISABLED=16,
                                       TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                       TOO_CLOSE_TO_OTHER=19,
                                       TOO_MANY_PIXELS=20, TOO_MANY_COLUMNS=21,
                                       TOO_MANY_ROWS=22, OPEN=23, CLOSED=24,
                                       RATE_TOO_HIGH=25),
    'TRACKER2__RATE_AID_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                       TOO_FEW_STARS=3, QUEST_FAILED=4,
                                       RESIDUALS_TOO_HIGH=5,
                                       TOO_CLOSE_TO_EDGE=6, PIX_AMP_TOO_LOW=7,
                                       PIX_AMP_TOO_HIGH=8, BACKGND_TOO_HIGH=9,
                                       TRACK_FAILURE=10, PIX_SUM_TOO_LOW=11,
                                       UNUSED=12, TOO_DIM_FOR_STARID=13,
                                       TOO_MANY_GROUPS=14, TOO_FEW_GROUPS=15,
                                       CHANNEL_DISABLED=16,
                                       TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                       TOO_CLOSE_TO_OTHER=19,
                                       TOO_MANY_PIXELS=20, TOO_MANY_COLUMNS=21,
                                       TOO_MANY_ROWS=22, OPEN=23, CLOSED=24,
                                       RATE_TOO_HIGH=25),
    'TRACKER2__VEL_AID_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                      TOO_FEW_STARS=3, QUEST_FAILED=4,
                                      RESIDUALS_TOO_HIGH=5,
                                      TOO_CLOSE_TO_EDGE=6, PIX_AMP_TOO_LOW=7,
                                      PIX_AMP_TOO_HIGH=8, BACKGND_TOO_HIGH=9,
                                      TRACK_FAILURE=10, PIX_SUM_TOO_LOW=11,
                                      UNUSED=12, TOO_DIM_FOR_STARID=13,
                                      TOO_MANY_GROUPS=14, TOO_FEW_GROUPS=15,
                                      CHANNEL_DISABLED=16,
                                      TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                      TOO_CLOSE_TO_OTHER=19,
                                      TOO_MANY_PIXELS=20, TOO_MANY_COLUMNS=21,
                                      TOO_MANY_ROWS=22, OPEN=23, CLOSED=24,
                                      RATE_TOO_HIGH=25),
    'TRACKER2__ATT_AID_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1, BAD=2,
                                      TOO_FEW_STARS=3, QUEST_FAILED=4,
                                      RESIDUALS_TOO_HIGH=5,
                                      TOO_CLOSE_TO_EDGE=6, PIX_AMP_TOO_LOW=7,
                                      PIX_AMP_TOO_HIGH=8, BACKGND_TOO_HIGH=9,
                                      TRACK_FAILURE=10, PIX_SUM_TOO_LOW=11,
                                      UNUSED=12, TOO_DIM_FOR_STARID=13,
                                      TOO_MANY_GROUPS=14, TOO_FEW_GROUPS=15,
                                      CHANNEL_DISABLED=16,
                                      TRACK_BLK_OVERLAP=17, OK_FOR_STARID=18,
                                      TOO_CLOSE_TO_OTHER=19,
                                      TOO_MANY_PIXELS=20, TOO_MANY_COLUMNS=21,
                                      TOO_MANY_ROWS=22, OPEN=23, CLOSED=24,
                                      RATE_TOO_HIGH=25),
    'TRACKER2__VECTOR_AID_STATUS' / Enum(BitsInteger(8), OK=0, PENDING=1,
                                         BAD=2, TOO_FEW_STARS=3,
                                         QUEST_FAILED=4, RESIDUALS_TOO_HIGH=5,
                                         TOO_CLOSE_TO_EDGE=6,
                                         PIX_AMP_TOO_LOW=7, PIX_AMP_TOO_HIGH=8,
                                         BACKGND_TOO_HIGH=9, TRACK_FAILURE=10,
                                         PIX_SUM_TOO_LOW=11, UNUSED=12,
                                         TOO_DIM_FOR_STARID=13,
                                         TOO_MANY_GROUPS=14, TOO_FEW_GROUPS=15,
                                         CHANNEL_DISABLED=16,
                                         TRACK_BLK_OVERLAP=17,
                                         OK_FOR_STARID=18,
                                         TOO_CLOSE_TO_OTHER=19,
                                         TOO_MANY_PIXELS=20,
                                         TOO_MANY_COLUMNS=21, TOO_MANY_ROWS=22,
                                         OPEN=23, CLOSED=24, RATE_TOO_HIGH=25),
    'TRACKER2__ATT_TIME_TAG' / BitsInteger(32),
    'TRACKER2__NUM_ID_PATTERNS_TRIED' / BitsInteger(32),
    'TRACKER2__PIXEL_AMP_THRESHOLD' / LinearAdapter(0.25, BitsInteger(8)),
    'TRACKER2__AMPLITUDE_OFFSET' / BitsInteger(8),
    'TRACKER2__CURRENT_TINT' / BitsInteger(32),
    'TRACKER2__VIDEO_ADDRESS' / BitsInteger(32),
    'TRACKER2__MAXIMUM_RESIDUAL_ID' / BitsInteger(16),
    'TRACKER2__MAXIMUM_RESIDUAL_ID_INIT' / BitsInteger(16),
    'TRACKER2__MAX_ROW_BCKGND_POST_COMP' / BitsInteger(16),
    'TRACKER2__NUM_PIX_GROUPS_FOR_ID' / BitsInteger(8),
    'TRACKER2__ID_TOLERANCE' / BitsInteger(8),
    'TRACKER2__NUM_OF_ATT_LOOPS' / BitsInteger(8),
    'TRACKER2__NUM_ATTITUDE_STARS' / BitsInteger(8),
    'TRACKER2__NUM_STARS_HIGH_RESIDUAL' / BitsInteger(8),
    'TRACKER2__AUTO_BLACK_ENABLE' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER2__BLACK_LEVEL' / BitsInteger(8),
    'TRACKER2__NUM_STARS_ON_FOV' / BitsInteger(8),
    'TRACKER2__NUM_TRACK_BLOCKS_ISSUED' / BitsInteger(8),
    'TRACKER2__NUM_TRACK_STARS' / BitsInteger(8),
    'TRACKER2__NUM_ID_STARS' / BitsInteger(8),
    'TRACKER2__FS_WCOUNTER' / BitsInteger(8),
    'TRACKER2__AUTO_TRACK' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER2__AUTO_INTEGRATION' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER2__AUTO_GAIN' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER2__TEST_MODE' / BitsInteger(8),
    'TRACKER2__FPGA_DET_TIMEOUT' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER2__STORE_SEQ_IMAGES' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER2__TRACK_REF_AVAILABLE' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER2__IMAGE_INDEX' / BitsInteger(8),
    'TRACKER2__REF_INDEX' / BitsInteger(8),
    'TRACKER2__NUM_BRIGHT_STARS' / BitsInteger(8),
    'TRACKER2__IMAGE_FILTER_ENABLED' / BitsInteger(8),
)

GPS = BitStruct(
    'GPS__TIME' / BitsInteger(32),
    'GPS__POSITION_ECEF1' / LinearAdapter(50000, BitsInteger(32)),
    'GPS__POSITION_ECEF2' / LinearAdapter(50000, BitsInteger(32)),
    'GPS__POSITION_ECEF3' / LinearAdapter(50000, BitsInteger(32)),
    'GPS__VELOCITY_ECEF1' / LinearAdapter(200000000, BitsInteger(32)),
    'GPS__VELOCITY_ECEF2' / LinearAdapter(200000000, BitsInteger(32)),
    'GPS__VELOCITY_ECEF3' / LinearAdapter(200000000, BitsInteger(32)),
    'GPS__SAMPLE_USEC_CT' / BitsInteger(32),
    'GPS__CYCLES_SINCE_LATEST_DATA' / BitsInteger(32),
    'GPS__GPS_LOCK_COUNT' / BitsInteger(16),
    'GPS__MS_GTRACKED_SATELLITES' / BitsInteger(8),
    'GPS__MS_GUSED_SATELLITES' / BitsInteger(8),
    'GPS__MSG_DATA_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'GPS__GPS_VALID' / Enum(BitsInteger(8), YES=1, NO=0),
    'GPS__GPS_ENABLE' / Enum(BitsInteger(8), YES=1, NO=0),
    'GPS__NEW_DATA_RECEIVED' / Enum(BitsInteger(8), YES=1, NO=0),
)

EVENT_CHECK = BitStruct(
    'EVENT_CHECK__RESPONSE_FIRE_COUNT' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK1' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK2' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK3' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK4' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK5' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK6' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK7' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK8' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK9' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK10' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK11' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK12' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK13' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK14' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK15' / BitsInteger(8),
    'EVENT_CHECK__CHECK_ENABLED_PACK16' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK1' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK2' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK3' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK4' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK5' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK6' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK7' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK8' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK9' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK10' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK11' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK12' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK13' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK14' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK15' / BitsInteger(8),
    'EVENT_CHECK__RESPONSE_ENABLED_PACK16' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK1' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK2' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK3' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK4' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK5' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK6' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK7' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK8' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK9' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK10' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK11' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK12' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK13' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK14' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK15' / BitsInteger(8),
    'EVENT_CHECK__LATCHED_RESP_FIRE_PACK16' / BitsInteger(8),
)

RADIO = BitStruct(
    'RADIO__SD_MINUTE_CUR' / BitsInteger(32),
    'RADIO__SD_MINUTE_MIN' / BitsInteger(32),
    'RADIO__SD_MINUTE_MIN_FSW' / BitsInteger(32),
    'RADIO__SD_MINUTE_MIN_SOH' / BitsInteger(32),
    'RADIO__SD_MINUTE_MIN_LINE' / BitsInteger(32),
    'RADIO__SD_MINUTE_MIN_TBL' / BitsInteger(32),
    'RADIO__SD_MINUTE_MIN_PAY' / BitsInteger(32),
    'RADIO__SD_PERCENT_USED_TOTAL' / BitsInteger(8),
    'RADIO__SD_PERCENT_USED_FSW' / BitsInteger(8),
    'RADIO__SD_PERCENT_USED_SOH' / BitsInteger(8),
    'RADIO__SD_PERCENT_USED_LINE' / BitsInteger(8),
    'RADIO__SD_PERCENT_USED_TBL' / BitsInteger(8),
    'RADIO__SD_PERCENT_USED_PAY' / BitsInteger(8),
    'RADIO__SD_REDUCTION_FLAGS' / BitsInteger(8),
    'RADIO__SD_OK' / Enum(BitsInteger(8), YES=1, NO=0),
    'RADIO__SD_FAULT_COUNT' / BitsInteger(8),
    'RADIO__SD_PRI_MOUNT_STATUS' / Enum(BitsInteger(8), NONE=0, MOUNT_DEV0=1,
                                        MOUNT_DEV1=2),
    'RADIO__SD_RED_MOUNT_STATUS' / Enum(BitsInteger(8), NONE=0, MOUNT_DEV0=1,
                                        MOUNT_DEV1=2),
    'RADIO__SDR_TX_TX_FREQ' / LinearAdapter(0.1, BitsInteger(32)),
    'RADIO__SDR_TX_TX_SYM_RATE' / BitsInteger(32),
    'RADIO__SDR_TX_TX_FRAMES' / BitsInteger(32),
    'RADIO__SDR_TX_TX_BYTES' / BitsInteger(32),
    'RADIO__SDR_TX_TX_MOD' / Enum(BitsInteger(8), BPSK=0, OQPSK=1, _8PSK=2),
    'RADIO__SDR_TX_TX_CODE' / Enum(BitsInteger(8), NONE=0, CC7_1_2=1,
                                   CC7_1_2_IQSWAP=2, CC7_1_2_IG2=3,
                                   CC7_1_2_IQSWAP_IG2=4),
    'RADIO__SDR_TX_TX_PCM' / Enum(BitsInteger(8), NRZL=0, NRZM=1),
    'RADIO__SDR_TX_TX' / Enum(BitsInteger(8), NO=0, YES=1),
    'RADIO__SDR_TX_TX_POWER' / BitsInteger(8),
    'RADIO__SDR_TX_TEMP' / BitsInteger(8),
    'RADIO__SDR_TX_COMM_ERROR' / Enum(BitsInteger(8), NO=0, YES=1),
    'RADIO__SQ_CHANNEL' / BitsInteger(8),
    'RADIO__SQ_CHECKSUM1' / BitsInteger(8),
    'RADIO__SQ_CHECKSUM2' / BitsInteger(8),
    'RADIO__SQ_CHECKSUM3' / BitsInteger(8),
    'RADIO__SQ_WDT_COUNT' / BitsInteger(8),
    'RADIO__SQ_TRAP_COUNT' / BitsInteger(8),
    'RADIO__SQ_TX_PLL_COUNT' / BitsInteger(8),
    'RADIO__SQ_TX_LOCK_STAT' / Enum(BitsInteger(8), LOCKED=0, UNLOCKED=1),
    'RADIO__SQ_TEMP' / BitsInteger(8),
    'RADIO__SQ_ECHO_STAT' / Enum(BitsInteger(8), ON=69, OFF=77),
    'RADIO__SQ_AFC_STAT' / Enum(BitsInteger(8), ON=70, OFF=71),
    'RADIO__SQ_SWD_STAT' / Enum(BitsInteger(8), ON=85, OFF=86),
    'RADIO__SQ_READBACK_STAT' / Enum(BitsInteger(8), BINARY=66, DECIMAL=78,
                                     HEX=84),
)

CAL = BitStruct(
    'CAL__Q_TRACKER_WRT_BODY1' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY2' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY3' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY4' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY5' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY6' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY7' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY8' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY_EST1' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY_EST2' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY_EST3' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY_EST4' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY_EST5' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY_EST6' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY_EST7' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__Q_TRACKER_WRT_BODY_EST8' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__TRACKER_ALIGN_USED_RES1' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__TRACKER_ALIGN_USED_RES2' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__TRACKER_ALIGN_USED_RES3' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__TRACKER_ALIGN_EST_RES1' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__TRACKER_ALIGN_EST_RES2' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__TRACKER_ALIGN_EST_RES3' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__REJECTED_TRACKER_EST_COUNT' / BitsInteger(32),
    'CAL__TRACKER_N' / BitsInteger(16),
    'CAL__TRACKER_ALIGN_METHOD' / Enum(BitsInteger(8), BATCH=0, RUNNING=1),
    'CAL__TRACKER_ALIGN_USAGE' / Enum(BitsInteger(8), TABLE=0, DYN=1),
    'CAL__GYRO_CAL_ALIGN1' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN2' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN3' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN4' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN5' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN6' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN7' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN8' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN9' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN_BEST1' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN_BEST2' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN_BEST3' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN_BEST4' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN_BEST5' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN_BEST6' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN_BEST7' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN_BEST8' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_ALIGN_BEST9' / LinearAdapter(1e9, BitsInteger(32)),
    'CAL__GYRO_CAL_BEST_UNC' / LinearAdapter(2e9, BitsInteger(32)),
    'CAL__GYRO_CAL_CURRENT_UNC' / LinearAdapter(2e9, BitsInteger(32)),
    'CAL__GYRO_CAL_RUNNING' / Enum(BitsInteger(8), OFF=0, ON=1),
)

TRACKER_CTRL = BitStruct(
    'TRACKER_CTRL__Q_BODY_WRT_ECI1' / LinearAdapter(1e9, BitsInteger(32)),
    'TRACKER_CTRL__Q_BODY_WRT_ECI2' / LinearAdapter(1e9, BitsInteger(32)),
    'TRACKER_CTRL__Q_BODY_WRT_ECI3' / LinearAdapter(1e9, BitsInteger(32)),
    'TRACKER_CTRL__Q_BODY_WRT_ECI4' / LinearAdapter(1e9, BitsInteger(32)),
    'TRACKER_CTRL__Q_BODY_WRT_ECI5' / LinearAdapter(1e9, BitsInteger(32)),
    'TRACKER_CTRL__Q_BODY_WRT_ECI6' / LinearAdapter(1e9, BitsInteger(32)),
    'TRACKER_CTRL__Q_BODY_WRT_ECI7' / LinearAdapter(1e9, BitsInteger(32)),
    'TRACKER_CTRL__Q_BODY_WRT_ECI8' / LinearAdapter(1e9, BitsInteger(32)),
    'TRACKER_CTRL__TRACKER_ATT_VALID1' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER_CTRL__TRACKER_ATT_VALID2' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER_CTRL__TRACKER_USAGE_ENABLED1' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER_CTRL__TRACKER_USAGE_ENABLED2' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER_CTRL__MAX_BACKGND_TRIPPED1' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER_CTRL__MAX_BACKGND_TRIPPED2' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER_CTRL__MAX_ROT_RATE_TRIPPED1' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER_CTRL__MAX_ROT_RATE_TRIPPED2' / Enum(BitsInteger(8), YES=1, NO=0),
    'TRACKER_CTRL__AID_STATUS1' / BitsInteger(8),
    'TRACKER_CTRL__AID_STATUS2' / BitsInteger(8),
    'TRACKER_CTRL__STAR_ID_STATUS' / BitsInteger(8),
)

POWER = BitStruct(
    'POWER__HEATER_CTRL_CONFIG1' / Enum(BitsInteger(8), MANUAL_OFF=1,
                                        MANUAL_ON=2, SURVIVAL=3, OPERATING=4),
    'POWER__HEATER_CTRL_CONFIG2' / Enum(BitsInteger(8), MANUAL_OFF=1,
                                        MANUAL_ON=2, SURVIVAL=3, OPERATING=4),
    'POWER__HEATER_STATUS1' / Enum(BitsInteger(8), OFF=0, ON=1),
    'POWER__HEATER_STATUS2' / Enum(BitsInteger(8), OFF=0, ON=1),
    Padding(6),
    'POWER__IO26_OUT_PLD_RST_REQ' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO25_OUT_PLD_FLASH_CS' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO24_OUT_' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO23_OUT_' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO22_OUT_REL2_EN' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO21_OUT_' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO20_OUT_PLD_HTR2' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO19_OUT_PLD_VBUS' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO18_OUT_REL1_EN' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO17_OUT_' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO16_IN_BAT_CHG_STAT' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO15_OUT_' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO14_OUT_12V_MODE' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO13_IN_' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO12_OUT_12V_EN' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO11_IN_SEP_MON' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO10_OUT_PLD_12V' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO9_OUT_PLD_HTR1' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO8_OUT_PLD_5V' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO7_OUT_PLD_5V' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO6_OUT_PLD_5V' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO5_OUT_PLD_3P3V' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO4_OUT_PLD_3P3V' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO3_OUT_GPS' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO2_OUT_SDR_12V' / Enum(Flag, ON=1, OFF=0),
    'POWER__IO1_OUT_RF_8V' / Enum(Flag, ON=1, OFF=0),
    'POWER__I2C_ERR_COUNT' / BitsInteger(8),
    'POWER__I2C_RETRY_COUNT' / BitsInteger(8)
)

cute_bct_fsw = Struct(
    'L0' / L0,
    'COMMAND_TLM' / COMMAND_TLM,
    'GENERAL' / GENERAL,
    'TIME' / TIME,
    'REFS' / REFS,
    'ATT_DET' / ATT_DET,
    'ATT_CMD' / ATT_CMD,
    'RW_DRIVE' / RW_DRIVE,
    'TRACKER' / TRACKER,
    'ATT_CTRL' / ATT_CTRL,
    'MOMENTUM' / MOMENTUM,
    'CSS' / CSS,
    'MAG' / MAG,
    'IMU' / IMU,
    'CLOCK_SYNC' / CLOCK_SYNC,
    'PAYLOAD' / PAYLOAD,
    'TLM_PROC' / TLM_PROC,
    'ANALOGS' / ANALOGS,
    'TABLES' / TABLES,
    'TRACKER2' / TRACKER2,
    'GPS' / GPS,
    'EVENT_CHECK' / EVENT_CHECK,
    'RADIO' / RADIO,
    'CAL' / CAL,
    'TRACKER_CTRL' / TRACKER_CTRL,
    'POWER' / POWER,
)
