# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=amdgcn -mcpu=gfx1200 --timeline --iterations=1 --timeline-max-cycles=0 < %s | FileCheck %s

v_s_exp_f32 s0, s0
v_s_log_f32 s0, s0
v_s_rcp_f32 s1, s1
v_s_rsq_f32 s1, s0
v_s_sqrt_f32 s2, s1
v_s_exp_f16 s3, s1
v_s_log_f16 s4, s1
v_s_rcp_f16 s5, s2
v_s_rsq_f16 s5, s4
v_s_sqrt_f16 s5, s5

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      10
# CHECK-NEXT: Total Cycles:      45
# CHECK-NEXT: Total uOps:        10

# CHECK:      Dispatch Width:    1
# CHECK-NEXT: uOps Per Cycle:    0.22
# CHECK-NEXT: IPC:               0.22
# CHECK-NEXT: Block RThroughput: 10.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      7     1.00                  U     v_s_exp_f32 s0, s0
# CHECK-NEXT:  1      7     1.00                  U     v_s_log_f32 s0, s0
# CHECK-NEXT:  1      7     1.00                  U     v_s_rcp_f32 s1, s1
# CHECK-NEXT:  1      7     1.00                  U     v_s_rsq_f32 s1, s0
# CHECK-NEXT:  1      7     1.00                  U     v_s_sqrt_f32 s2, s1
# CHECK-NEXT:  1      7     1.00                  U     v_s_exp_f16 s3, s1
# CHECK-NEXT:  1      7     1.00                  U     v_s_log_f16 s4, s1
# CHECK-NEXT:  1      7     1.00                  U     v_s_rcp_f16 s5, s2
# CHECK-NEXT:  1      7     1.00                  U     v_s_rsq_f16 s5, s4
# CHECK-NEXT:  1      7     1.00                  U     v_s_sqrt_f16 s5, s5

# CHECK:      Resources:
# CHECK-NEXT: [0]   - HWBranch
# CHECK-NEXT: [1]   - HWExport
# CHECK-NEXT: [2]   - HWLGKM
# CHECK-NEXT: [3]   - HWRC
# CHECK-NEXT: [4]   - HWSALU
# CHECK-NEXT: [5]   - HWVALU
# CHECK-NEXT: [6]   - HWVMEM

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]
# CHECK-NEXT:  -      -      -     10.00   -     10.00   -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_exp_f32 s0, s0
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_log_f32 s0, s0
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_rcp_f32 s1, s1
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_rsq_f32 s1, s0
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_sqrt_f32 s2, s1
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_exp_f16 s3, s1
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_log_f16 s4, s1
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_rcp_f16 s5, s2
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_rsq_f16 s5, s4
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -     v_s_sqrt_f16 s5, s5

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          01234

# CHECK:      [0,0]     DeeeeeeE  .    .    .    .    .    .    .   .   v_s_exp_f32 s0, s0
# CHECK-NEXT: [0,1]     .    . DeeeeeeE.    .    .    .    .    .   .   v_s_log_f32 s0, s0
# CHECK-NEXT: [0,2]     .    .  DeeeeeeE    .    .    .    .    .   .   v_s_rcp_f32 s1, s1
# CHECK-NEXT: [0,3]     .    .    .   DeeeeeeE   .    .    .    .   .   v_s_rsq_f32 s1, s0
# CHECK-NEXT: [0,4]     .    .    .    .    .DeeeeeeE .    .    .   .   v_s_sqrt_f32 s2, s1
# CHECK-NEXT: [0,5]     .    .    .    .    . DeeeeeeE.    .    .   .   v_s_exp_f16 s3, s1
# CHECK-NEXT: [0,6]     .    .    .    .    .  DeeeeeeE    .    .   .   v_s_log_f16 s4, s1
# CHECK-NEXT: [0,7]     .    .    .    .    .    .  DeeeeeeE    .   .   v_s_rcp_f16 s5, s2
# CHECK-NEXT: [0,8]     .    .    .    .    .    .    DeeeeeeE  .   .   v_s_rsq_f16 s5, s4
# CHECK-NEXT: [0,9]     .    .    .    .    .    .    .    . DeeeeeeE   v_s_sqrt_f16 s5, s5

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       v_s_exp_f32 s0, s0
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       v_s_log_f32 s0, s0
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       v_s_rcp_f32 s1, s1
# CHECK-NEXT: 3.     1     0.0    0.0    0.0       v_s_rsq_f32 s1, s0
# CHECK-NEXT: 4.     1     0.0    0.0    0.0       v_s_sqrt_f32 s2, s1
# CHECK-NEXT: 5.     1     0.0    0.0    0.0       v_s_exp_f16 s3, s1
# CHECK-NEXT: 6.     1     0.0    0.0    0.0       v_s_log_f16 s4, s1
# CHECK-NEXT: 7.     1     0.0    0.0    0.0       v_s_rcp_f16 s5, s2
# CHECK-NEXT: 8.     1     0.0    0.0    0.0       v_s_rsq_f16 s5, s4
# CHECK-NEXT: 9.     1     0.0    0.0    0.0       v_s_sqrt_f16 s5, s5
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
