# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AttestBootIntegrityPropertyEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of whether the list of boot integrity properties is validated."""

    VALID = "Valid"
    """Boot integrity properties are valid"""
    INVALID = "Invalid"
    """Boot integrity properties are invalid"""
    UNKNOWN = "Unknown"
    """Boot integrity properties status is unknown"""


class AttestCertPropertyEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of whether attestation certificate is validated."""

    VALID = "Valid"
    """Attestation certificate is valid"""
    INVALID = "Invalid"
    """Attestation certificate is invalid"""
    UNKNOWN = "Unknown"
    """Attestation certificate status is unknown"""


class AttestDiskSecurityEncryptionTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines type of managed disk security encryption type from attestation token."""

    NON_PERSISTED_TPM = "NonPersistedTPM"
    """Disk security encryption type is non-persisted Trusted Platform Module (TPM)"""
    UNKNOWN = "Unknown"
    """Disk security encryption type is unknown"""


class AttestHealthStatusEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The health status of attestation validation and parsing."""

    PENDING = "Pending"
    """Attestation validation and parsing pending"""
    HEALTHY = "Healthy"
    """Attestation validation and parsing healthy"""
    UNHEALTHY = "Unhealthy"
    """Attestation validation and parsing unhealthy"""
    UNKNOWN = "Unknown"
    """Attestation validation and parsing status is unknown"""


class AttestHWPlatformEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines type of hardware platform from attestation token."""

    SEVSNP = "SEVSNP"
    """AttestHWPlatform is Secure Encrypted Virtualization Secure Nested Paging (SEVSNP)"""
    UNKNOWN = "Unknown"
    """AttestHWPlatform is unknown"""


class AttestSecureBootPropertyEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of whether secure boot is enabled."""

    ENABLED = "Enabled"
    """Secure boot enabled"""
    DISABLED = "Disabled"
    """Secure boot disabled"""
    UNKNOWN = "Unknown"
    """Secure boot status is unknown"""


class CloudInitDataSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]."""

    NO_CLOUD = "NoCloud"
    """NoCloud is used as the datasource"""
    AZURE = "Azure"
    """Azure is used as the datasource"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DiskFileFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The format of the actual VHD file [vhd, vhdx]."""

    VHDX = "vhdx"
    """VHDX file format"""
    VHD = "vhd"
    """VHD file format"""


class ExtendedLocationTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of extendedLocation."""

    CUSTOM_LOCATION = "CustomLocation"
    """Custom extended location type"""


class GpuAssignmentTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gpu Assignment types."""

    GPU_DDA = "GpuDDA"
    """Attach Graphics Processing Unit (GPU) using Discrete Device Assignment (DDA)"""
    GPU_P = "GpuP"
    """Attach Graphics Processing Unit (GPU) using GPU Partitioning"""


class HyperVGeneration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The hypervisor generation of the Virtual Machine [V1, V2]."""

    V1 = "V1"
    """Generation 1 (V1) hypervisor"""
    V2 = "V2"
    """Generation 2 (V2) hypervisor"""


class IpAllocationMethodEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IPAllocationMethod - The IP address allocation method. Possible values include: 'Static',
    'Dynamic'.
    """

    DYNAMIC = "Dynamic"
    """Dynamic IP allocation method"""
    STATIC = "Static"
    """Static IP allocation method"""


class IPPoolTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the IP Pool [vm, vippool]."""

    VM = "vm"
    """Virtual Machine IP Pool"""
    VIPPOOL = "vippool"
    """VIP Pool"""


class LogicalNetworkTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Logical Network."""

    WORKLOAD = "Workload"
    """Logical Network of type Workload"""
    INFRASTRUCTURE = "Infrastructure"
    """Logical Network of type Infrastructure"""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class OperatingSystemTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operating system type that the gallery image uses [Windows, Linux]."""

    WINDOWS = "Windows"
    """Windows operating system"""
    LINUX = "Linux"
    """Linux operating system"""


class PowerStateEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The power state of the virtual machine instance."""

    DEALLOCATED = "Deallocated"
    """Virtual machine deallocated"""
    DEALLOCATING = "Deallocating"
    """Virtual machine deallocating"""
    RUNNING = "Running"
    """Virtual machine running"""
    STARTING = "Starting"
    """Virtual machine starting"""
    STOPPED = "Stopped"
    """Virtual machine stopped"""
    STOPPING = "Stopping"
    """Virtual machine stopping"""
    PAUSED = "Paused"
    """Virtual machine paused"""
    SAVED = "Saved"
    """Virtual machine Saved,"""
    UNKNOWN = "Unknown"
    """Power state of the virtual machine is unknown"""


class ProvisioningAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the different types of operations for guest agent."""

    INSTALL = "install"
    """Install guest agent"""
    UNINSTALL = "uninstall"
    """Uninstall guest agent"""
    REPAIR = "repair"
    """Repair guest agent"""


class ProvisioningStateEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the resource."""

    SUCCEEDED = "Succeeded"
    """Provisioning has succeeded"""
    FAILED = "Failed"
    """Provisioning has failed"""
    IN_PROGRESS = "InProgress"
    """Provisioning is in progress"""
    ACCEPTED = "Accepted"
    """Provisioning has been accepted"""
    DELETING = "Deleting"
    """Deletion of the resource is in progress"""
    CANCELED = "Canceled"
    """Provisioning has been canceled"""


class SecurityEncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Encryption type of the managed disk enum."""

    NON_PERSISTED_TPM = "NonPersistedTPM"
    """Non-persisted TPM encryption type"""


class SecurityRuleAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether network traffic is allowed or denied."""

    ALLOW = "Allow"
    """Network traffic is allowed"""
    DENY = "Deny"
    """Network traffic is denied"""


class SecurityRuleDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The direction of the rule. The direction specifies if rule will be evaluated on incoming or
    outgoing traffic.
    """

    INBOUND = "Inbound"
    """Rule is evaluated on incoming traffic"""
    OUTBOUND = "Outbound"
    """Rule is evaluated on outgoing traffic"""


class SecurityRuleProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network protocol this rule applies to."""

    TCP = "Tcp"
    """Transmission Control Protocol"""
    UDP = "Udp"
    """User Datagram Protocol"""
    ICMP = "Icmp"
    """Internet Control Message Protocol"""
    ASTERISK = "*"
    """Wildcard rule for all protocols"""


class SecurityTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the SecurityType of the virtual machine. EnableTPM and SecureBootEnabled must be set
    to true for SecurityType to function.
    """

    TRUSTED_LAUNCH = "TrustedLaunch"
    """Trusted Launch security type"""
    CONFIDENTIAL_VM = "ConfidentialVM"
    """Confidential VM security type"""


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the operation performed on the resource [Succeeded, Failed, InProgress]."""

    SUCCEEDED = "Succeeded"
    """Operation succeeded"""
    FAILED = "Failed"
    """Operation failed"""
    IN_PROGRESS = "InProgress"
    """Operation is in progress"""


class StatusLevelTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The level code."""

    INFO = "Info"
    """Informational status level"""
    WARNING = "Warning"
    """Warning status level"""
    ERROR = "Error"
    """Error status level"""


class StatusTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The installation status of the hybrid machine agent installation."""

    SUCCEEDED = "Succeeded"
    """Installation succeeded"""
    IN_PROGRESS = "InProgress"
    """Installation in progress"""
    FAILED = "Failed"
    """Installation failed"""


class VmSizeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VM Sizes."""

    DEFAULT = "Default"
    """Default virtual machine size"""
    STANDARD_A2_V2 = "Standard_A2_v2"
    """Standard A2 v2 virtual machine size"""
    STANDARD_A4_V2 = "Standard_A4_v2"
    """Standard A4 v2 virtual machine size"""
    STANDARD_D2_S_V3 = "Standard_D2s_v3"
    """Standard D2s v3 virtual machine size"""
    STANDARD_D4_S_V3 = "Standard_D4s_v3"
    """Standard D4s v3 virtual machine size"""
    STANDARD_D8_S_V3 = "Standard_D8s_v3"
    """Standard D8s v3 virtual machine size"""
    STANDARD_D16_S_V3 = "Standard_D16s_v3"
    """Standard D16s v3 virtual machine size"""
    STANDARD_D32_S_V3 = "Standard_D32s_v3"
    """Standard D32s v3 virtual machine size"""
    STANDARD_DS2_V2 = "Standard_DS2_v2"
    """Standard DS2 v2 virtual machine size"""
    STANDARD_DS3_V2 = "Standard_DS3_v2"
    """Standard DS3 v2 virtual machine size"""
    STANDARD_DS4_V2 = "Standard_DS4_v2"
    """Standard DS4 v2 virtual machine size"""
    STANDARD_DS5_V2 = "Standard_DS5_v2"
    """Standard DS5 v2 virtual machine size"""
    STANDARD_DS13_V2 = "Standard_DS13_v2"
    """Standard DS13 v2 virtual machine size"""
    STANDARD_K8_S_V1 = "Standard_K8S_v1"
    """Standard K8S v1 virtual machine size"""
    STANDARD_K8_S2_V1 = "Standard_K8S2_v1"
    """Standard K8S2 v1 virtual machine size"""
    STANDARD_K8_S3_V1 = "Standard_K8S3_v1"
    """Standard K8S3 v1 virtual machine size"""
    STANDARD_K8_S4_V1 = "Standard_K8S4_v1"
    """Standard K8S4 v1 virtual machine size"""
    STANDARD_NK6 = "Standard_NK6"
    """Standard NK6 virtual machine size"""
    STANDARD_NK12 = "Standard_NK12"
    """Standard NK12 virtual machine size"""
    STANDARD_NV6 = "Standard_NV6"
    """Standard NV6 virtual machine size"""
    STANDARD_NV12 = "Standard_NV12"
    """Standard NV12 virtual machine size"""
    STANDARD_K8_S5_V1 = "Standard_K8S5_v1"
    """Standard K8S5 v1 virtual machine size"""
    CUSTOM = "Custom"
    """Custom virtual machine size"""
