% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{ExGaussian}
\alias{ExGaussian}
\alias{dexgaussian}
\alias{pexgaussian}
\alias{rexgaussian}
\title{The Exponentially Modified Gaussian Distribution}
\usage{
dexgaussian(x, mu, sigma, beta, log = FALSE)

pexgaussian(q, mu, sigma, beta, lower.tail = TRUE, log.p = FALSE)

rexgaussian(n, mu, sigma, beta)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{mu}{Vector of means of the combined distribution.}

\item{sigma}{Vector of standard deviations of the gaussian component.}

\item{beta}{Vector of scales of the exponential component.}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x).
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{n}{Number of draws to sample from the distribution.}
}
\description{
Density, distribution function, and random generation
for the exponentially modified Gaussian distribution with
mean \code{mu} and standard deviation \code{sigma} of the gaussian
component, as well as scale \code{beta} of the exponential
component.
}
\details{
See \code{vignette("brms_families")} for details
on the parameterization.
}
