# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

import sys
import os

import sphinx_rtd_theme

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information

# General information about the project.
project = u'SeqAn'
copyright = u'2015, The SeqAn Team'

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

extensions = [
    'sphinx.ext.todo',
    'sphinx.ext.mathjax',
    'sphinx.ext.ifconfig',
    'sphinxcontrib.bibtex',
    'seqansphinx.doxlinks',
    'seqansphinx.includefrags',
]

[extensions]
todo_include_todos=True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8-sig'

# bibliography file for sphinxcontrib.bibtex
bibtex_bibfiles = ['seqan.bib']

# The master toctree document.
master_doc = 'index'

# <-- SeqAn: Determine current branch ----------------------------------------------

# Get the current seqan-branch from the READTHEDOCS_VERSION enviornment variable.
# If it is not set, e.g., if you build it manually for testing you can export
# this variable before calling make html in the manual directory to match your
# checked out branch.
seqan_branch = os.environ.get('READTHEDOCS_VERSION', 'main')

# -- SeqAn: Determine current branch ---------------------------------------------->

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = seqan_branch.replace('seqan-v','')
# The full version, including alpha/beta/rc tags.
release = version
pygments_style = 'sphinx'


# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

html_theme = 'sphinx_rtd_theme'
html_static_path = ['_static']
htmlhelp_basename = 'seqandoc'

# -- Options for LaTeX output ---------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-latex-output

latex_documents = [
  ('index', 'SeqAn.tex', u'SeqAn Manual',
   u'The SeqAn Team', 'manual'),
]

# -- Options for manual page output ---------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-manual-page-output

man_pages = [
    ('index', 'seqan', u'SeqAn Manual',
     [u'The SeqAn Team'], 1)
]

# -- Options for Texinfo output -------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-texinfo-output

texinfo_documents = [
  ('index', 'SeqAn', u'SeqAn Manual',
   u'The SeqAn Team', 'SeqAn', 'One line description of project.',
   'Miscellaneous'),
]

# -- Options for SeqAn plugins ----------------------------------------------

# Configure the base URL for dox links.  By default, we point to the main
# branch, but if we are on readthedocs then we compute the URL from the
# RTD_VERSION_SLUG configured by the rtd environment.
doxlinks_base_url = 'https://docs.seqan.de/seqan/%s/' % version

# Set path to JSON index generated by dox.
doxlinks_dox_json = "../dox/html/js/search.data.js"

# Set base dir for inclusion of fragments.
includefrags_base_dir = '../..'
