---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              matrice, tableau
---

# Comment composer une matrice ?

## Avec les commandes de base

Il suffit de construire un tableau sans lignes avec l'environnement `array`
comme dans cet exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[\left(
  \begin{array}{ccc}
    x_{11} & \cdots & x_{1p} \\
    \vdots & \ddots & \vdots \\
    x_{n1} & \cdots & x_{np}
  \end{array}
  \right)
\]
\end{document}
```

Pour savoir comment encadrer cette matrice avec des délimiteurs, 
vous pouvez consulter la question 
"[](/4_domaines_specialises/mathematiques/structures/delimiteurs/ajuster_la_taille_des_delimiteurs)".


## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) permet de définir 
une matrice de manière plus rapide qu'avec l'environnement `array`. 
Les environnements disponibles sont :
- `matrix` pour une matrice sans éléments encadrants ;
- `pmatrix` pour une matrice encadrée par des parenthèses ;
- `bmatrix` pour une matrice encadrée par des crochets ;
- `vmatrix` pour une matrice encadrée par des lignes verticales ;
- `Vmatrix` pour une matrice encadrée par des doubles lignes verticales.

En voici un exemple d'utilisation :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[
  \begin{pmatrix}
    a & b \\
    c & d
  \end{pmatrix}
\]
\end{document}
```

## Avec l’extension <ctanpkg:nicematrix>

L’extension <ctanpkg:nicematrix> fournit des environnements similaires aux environnements `tabular`, 
`array` et `matrix` des packages <ctanpkg:array> et <ctanpkg:amsmath> mais avec des fonctionnalités 
supplémentaires.

Pour ce qui concerne les matrices, cette extension donne accès aux environnements suivants: 
- `NiceMatrix`;
- `pNiceMatrix`;
- `bNiceMatrix`;
- `BNiceMatrix`;
- `vNiceMatrix`;
- `VNiceMatrix`. 

Les paramètres se règlent sous forme de clé/valeur en argument des environnements. Pour régler 
les options de composition des matrices, on pourra aussi utiliser la commande `\NiceMatrixOptions`.

La documentation du package regorge d’exemples.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{nicematrix}

\begin{document}
\[
  \begin{pNiceMatrix}
    a & b \\
    c & d
  \end{pNiceMatrix}
\]

\[
  \begin{bNiceMatrix}
    a_1 & \Cdots & & & a_1 \\
    \Vdots & a_2 & \Cdots & & a_2 \\
    & \Vdots & \Ddots[color=red] \\
    \\
    a_1 & a_2 & & & a_n
  \end{bNiceMatrix}
\]
\NiceMatrixOptions{renew-dots,renew-matrix}
\[
  \begin{pmatrix}
    1 & \cdots & \cdots & 1 \\
    0 & \ddots & & \vdots \\
    \vdots & \ddots & \ddots & \vdots \\
    0 & \cdots & 0 & 1
  \end{pmatrix}
\]
\end{document}
```




## Avec l'extension <ctanpkg:easymat> 

```{attention}
Ce package n’a pas été mis à jour depuis 2002.
```

L'extension <ctanpkg:easymat> aide également à l'écriture de matrices.
Elle fournit l’environnement `MAT` qui est une réimplémentation des environnements 
`array` et `tabular` avec quelques limites et quelques fonctionnalités supplémentaires, 
notamment une gestion plus développée des traits, des espacements et des alignements.  

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}
  \usepackage{easymat}

\begin{document}
\[\left[
  \begin{MAT}(@,50pt,20pt){c.c}
    1 & 22 \\.
    \frac{1}{2} & 1 \\
  \end{MAT}
  \right] 
\]
\end{document}
```



## Avec l'extension <ctanpkg:easybmat> 

```{attention}
Ce package n’a pas été mis à jour depuis 2002.
```

L'extension <ctanpkg:easybmat> fournit des éléments pour écrire des matrices
par bloc. Elle fournit l’environnement `BMAT` très proche de l’environnement `MAT` 
de l’extension <ctanpkg:easymat> (du même auteur). 
Là encore, ce package permet une gestion fine des traits, des espacements et des alignements. 

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}
  \usepackage{easybmat}

\begin{document}

\[\left(
  \begin{BMAT}[5pt]{cccccc}{cccccc}
    1 & * & * & * & * & * \\
    0 & 11 & * & * & * & * \\
    0 & 0 & 111 & * & * & * \\
    0 & 0 & 0 & 1111 & * & * \\
    0 & 0 & 0 & 0 & 11111 & * \\
    0 & 0 & 0 & 0 & 0 & 11111
    \addpath{(0,5,.)rdrdrdrdrd}
  \end{BMAT}
  \right) 
\]

\end{document}
```



:::{sources}
[Pantigny, F. 2021. _Aperçu du package nicematrix_. La _Lettre GUTenberg_. 44 (sept. 2021), 29–36](https://doi.org/10.60028/lettre.vi44.19)
:::
